% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_statistics.R
\name{report_statistics}
\alias{report_statistics}
\title{Report the statistics of a model}
\usage{
report_statistics(x, table = NULL, ...)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{table}{A table obtained via \code{report_table()}. If not provided,
will run it.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{\link{report_statistics}}.
}
\description{
Creates a list containing a description of the parameters' values of R
objects (see list of supported objects in \code{\link{report}}). Useful to
insert in parentheses in plots or reports.
}
\examples{
library(report)

# Data
report_statistics(iris$Sepal.Length)
report_statistics(as.character(round(iris$Sepal.Length, 1)))
report_statistics(iris$Species)
report_statistics(iris)

# h-tests
report_statistics(t.test(iris$Sepal.Width, iris$Sepal.Length))
report_statistics(cor.test(iris$Sepal.Width, iris$Sepal.Length))

# ANOVA
report_statistics(aov(Sepal.Length ~ Species, data = iris))

# GLMs
report_statistics(lm(Sepal.Length ~ Petal.Length * Species, data = iris))
report_statistics(glm(vs ~ disp, data = mtcars, family = "binomial"))

\donttest{
# Mixed models
if (require("lme4")) {
  model <- lme4::lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
  report_statistics(model)
}

# Bayesian models
if (require("rstanarm")) {
  model <- stan_glm(Sepal.Length ~ Species, data = iris, refresh = 0, iter = 600)
  report_statistics(model)
}
}
}
