% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rm_survsum}
\alias{rm_survsum}
\title{Summarise survival data by group}
\usage{
rm_survsum(
  data,
  time,
  status,
  group = NULL,
  survtimes = NULL,
  survtimeunit,
  survtimesLbls = NULL,
  CIwidth = 0.95,
  unformattedp = FALSE,
  conf.type = "log",
  na.action = "na.omit",
  showCounts = TRUE,
  showLogrank = TRUE,
  eventProb = FALSE,
  digits = getOption("reportRmd.digits", 2),
  caption = NULL,
  tableOnly = FALSE,
  fontsize
)
}
\arguments{
\item{data}{data frame containing survival data}

\item{time}{string indicating survival time variable}

\item{status}{string indicating event status variable}

\item{group}{string or character vector indicating the variable(s) to group
observations by. If this is left as NULL (the default) then summaries are
provided for the entire cohort.}

\item{survtimes}{numeric vector specifying when survival probabilities should
be calculated.}

\item{survtimeunit}{unit of time to suffix to the time column label if
survival probabilities are requested, should be plural}

\item{survtimesLbls}{if supplied, a vector the same length as survtimes with
descriptions (useful for displaying years with data provided in months)}

\item{CIwidth}{width of the survival probabilities, default is 95\%}

\item{unformattedp}{boolean indicating if you would like the p-value to be
returned unformatted (ie not rounded or prefixed with '<'). Should be used
in conjunction with the digits argument.}

\item{conf.type}{type of confidence interval see \code{\link{survfit}} for
details. Default is 'log'.}

\item{na.action}{default is to omit missing values, but can be set to throw
and error using na.action='na.fail'}

\item{showCounts}{boolean indicating if the at risk, events and censored
columns should be output; default is TRUE}

\item{showLogrank}{boolean indicating if the log-rank test statistic and
p-value should be output; default is TRUE}

\item{eventProb}{boolean indicating if event probabilities, rather than
survival probabilities, should be displayed; default is FALSE}

\item{digits}{the number of digits in the survival rate, default is 2, unless
the reportRmd.digits option is set}

\item{caption}{table caption for markdown output}

\item{tableOnly}{should a dataframe or a formatted object be returned}

\item{fontsize}{PDF/HTML output only, manually set the table fontsize}
}
\value{
A character vector of the survival table source code, unless
tableOnly=TRUE in which case a data frame is returned
}
\description{
Displays event counts, median survival time and survival rates at specified
times points for the entire cohort and by group. The logrank test of
differences in survival curves is displayed.
}
\details{
This summary table is supplied for simple group comparisons only. To examine
differences in groups with stratification see \code{\link{rm_survdiff}}. To
summarise differences in survival rates controlling for covariates see
\code{\link{rm_survtime}}.
}
\examples{
# Simple median survival table
data("pembrolizumab")
rm_survsum(data=pembrolizumab,time='os_time',status='os_status')

# Survival table with yearly survival rates
rm_survsum(data=pembrolizumab,time='os_time',status='os_status',
survtimes=c(12,24),survtimesLbls=1:2, survtimeunit='yr')

#Median survival by group
rm_survsum(data=pembrolizumab,time='os_time',status='os_status',group='sex')

# Survival Summary by cohort, displayed in years
rm_survsum(data=pembrolizumab,time='os_time',status='os_status',
group="cohort",survtimes=seq(12,72,12),
survtimesLbls=seq(1,6,1),
survtimeunit='years')

# Survival Summary by Sex and ctDNA group
rm_survsum(data=pembrolizumab,time='os_time',status='os_status',
group=c('sex','change_ctdna_group'),survtimes=c(12,24),survtimeunit='mo')

}
\seealso{
\code{\link{survfit}}
}
