% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalysisForFamiliesOfExperimentsSR.R
\name{calculateSmallSampleSizeAdjustment}
\alias{calculateSmallSampleSizeAdjustment}
\title{calculateSmallSampleSizeAdjustment}
\usage{
calculateSmallSampleSizeAdjustment(df, exact = TRUE)
}
\arguments{
\item{df}{A vector of degrees of freedom}

\item{exact}{Default value=TRUE, If exact==TRUE the function returns the exact value of the adjustment(s) which is suitable for small values of df, if exact==FALSE the function returns the approximate version of the adjustment(s). See Hedges and Olkin 'Statistical methods for Meta-Analysis' Academic Press 1985.}
}
\value{
small sample size adjustment value
}
\description{
Function calculates the small sample size adjustment for standardized mean effect sizes
}
\examples{
df <- 2
c <- calculateSmallSampleSizeAdjustment(df)

df=c(5,10,17)
adjexact=calculateSmallSampleSizeAdjustment(df)
# adjexact=0.8407487 0.9227456 0.9551115
# Hedges and Olkin values 0.8408, 0.9228,0.9551
adjapprox=calculateSmallSampleSizeAdjustment(df,FALSE)
# adjapprox=0.8421053 0.9230769 0.9552239
}
\author{
Barbara Kitchenham and Lech Madeyski
}
