% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperData.R
\docType{data}
\name{KitchenhamEtAl.CorrelationsAmongParticipants.Abrahao13TSE}
\alias{KitchenhamEtAl.CorrelationsAmongParticipants.Abrahao13TSE}
\title{KitchenhamEtAl.CorrelationsAmongParticipants.Abrahao13TSE data illustrate correlations between
results from individual participants in a family of five cross-over experiments conducted by
Abrahao et al:
[1] S. Abrahao, C. Gravino, E. Insfran Pelozo, G. Scanniello, and
G. Tortora, "Assessing the effectiveness of sequence diagrams in the comprehension of functional
requirements: Results from a family of five experiments," IEEE Transactions on Software
Engineering, vol. 39, no. 3, pp. 327–342, March 2013
The five experiments assess whether the comprehensibility of function requirements improve when
software models include UML sequence diagrams.
If you use this data set please cite:
[1] S. Abrahao, C. Gravino, E. Insfran Pelozo, G. Scanniello, and
G. Tortora, "Assessing the effectiveness of sequence diagrams in the comprehension of
functional requirements: Results from a family of five experiments," IEEE Transactions on
Software Engineering, vol. 39, no. 3, pp. 327–342, March 2013
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).}
\format{
A data frame with 224 rows and 8 variables:
\describe{
\item{ExperimentID}{<fct>|ExperimentID: A unique identifier for each of the five experiments in
the data set.}
\item{ParticipantID}{<fct>|Participant ID: An identifier for each participant, unique for a
specific experiment.}
\item{SequenceGroup}{<fct>|Experimental Sequence Group: A (DM-NODM,ECP-EPlat or MShop-Theatre ),
 B (NODM-DM,ECP-EPlat or  MShop-Theatre ), C(DM-NODM,EPlat-ECP or Theatre-MShop),
 D(NODM-DM,EPlat-ECP or Theatre-MShop)}
\item{System}{<fct>|Software systems used in the experiment: ECP an e-commerce platform from
which CDs and books can be bought,	EPlat a system for the management of courses, lectures and
students of a university, M-Shop a system for managing sales at a music shop, Theatre a system
for managing bookings for a theatre.}
\item{Period}{<fct>|Time period of the cross-over experiment: 1 or 2}
\item{Treatment}{<fct>|Experimental Treatment: A Dynamic Model (DM) vs No Dynamic Model (NODM)}
\item{Comprehension}{<dbl>|Dependent variable: The comprehension level the software engineer
achieved based on the F-measure }
\item{CrossOverID}{<fct>|CrossOver category: For 4 group crossover designs, the crossover
category specifies the matching pairs of sequence groups, CO1 and CO2. For a 2 group crossover,
the category is set to CO1 only}
\item{Ability}{<fct>|Ability: An assessment of the ability of participants: Low, High, NA (not
available)}
}
}
\usage{
KitchenhamEtAl.CorrelationsAmongParticipants.Abrahao13TSE
}
\description{
KitchenhamEtAl.CorrelationsAmongParticipants.Abrahao13TSE data illustrate correlations between
results from individual participants in a family of five cross-over experiments conducted by
Abrahao et al:
[1] S. Abrahao, C. Gravino, E. Insfran Pelozo, G. Scanniello, and
G. Tortora, "Assessing the effectiveness of sequence diagrams in the comprehension of functional
requirements: Results from a family of five experiments," IEEE Transactions on Software
Engineering, vol. 39, no. 3, pp. 327–342, March 2013
The five experiments assess whether the comprehensibility of function requirements improve when
software models include UML sequence diagrams.
If you use this data set please cite:
[1] S. Abrahao, C. Gravino, E. Insfran Pelozo, G. Scanniello, and
G. Tortora, "Assessing the effectiveness of sequence diagrams in the comprehension of
functional requirements: Results from a family of five experiments," IEEE Transactions on
Software Engineering, vol. 39, no. 3, pp. 327–342, March 2013
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).
}
\examples{
KitchenhamEtAl.CorrelationsAmongParticipants.Abrahao13TSE

}
\keyword{datasets}
