% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedMethods.R
\name{.dealWithClass}
\alias{.dealWithClass}
\alias{.dealWithClass.list}
\alias{.dealWithClass.environment}
\alias{.dealWithClass.default}
\alias{.dealWithClassOnRecovery.default}
\alias{.dealWithClassOnRecovery}
\alias{.dealWithClassOnRecovery.environment}
\alias{.dealWithClassOnRecovery.list}
\title{Deal with class for saving to and loading from Cache or Disk}
\usage{
.dealWithClass(
  obj,
  cachePath,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose")
)

\method{.dealWithClass}{list}(
  obj,
  cachePath,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose")
)

\method{.dealWithClass}{environment}(
  obj,
  cachePath,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose")
)

\method{.dealWithClass}{default}(
  obj,
  cachePath,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose")
)

\method{.dealWithClassOnRecovery}{default}(
  obj,
  cachePath,
  cacheId,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL)
)

.dealWithClassOnRecovery(
  obj,
  cachePath,
  cacheId,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL)
)

\method{.dealWithClassOnRecovery}{environment}(
  obj,
  cachePath,
  cacheId,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL)
)

\method{.dealWithClassOnRecovery}{list}(
  obj,
  cachePath,
  cacheId,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL)
)
}
\arguments{
\item{obj}{Any arbitrary R object.}

\item{cachePath}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{drv}{if using a database backend, drv must be an object that
inherits from DBIDriver e.g., \code{RSQLite::SQLite()}}

\item{conn}{an optional DBIConnection object, as returned by dbConnect().}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{cacheId}{Used strictly for messaging. This should be the cacheId of the object being recovered.}
}
\value{
Returns an object that can be saved to disk e.g., via \code{saveRDS}.
}
\description{
This generic and some methods will do whatever is required to prepare an object for
saving to disk (or RAM) via e.g., \code{saveRDS}. Some objects (e.g., \code{terra}'s \verb{Spat*})
cannot be saved without first wrapping them. Also, file-backed objects are similar.
}
