% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureImportance.R
\name{FeatureImportance}
\alias{FeatureImportance}
\title{Compute Feature Importance of a RerF model}
\usage{
FeatureImportance(forest, num.cores = 0L)
}
\arguments{
\item{forest}{a forest trained using the RerF function with argument store.impurity = TRUE}

\item{num.cores}{number of cores to use. If num.cores = 0, then 1 less than the number of cores reported by the OS are used. (num.cores = 0)}
}
\value{
feature.imp
}
\description{
Computes feature importance of every unique feature used to make a split in the RerF model.
}
\examples{
library(rerf)
forest <- RerF(as.matrix(iris[, 1:4]), iris[[5L]], num.cores = 1L, store.impurity = TRUE)
feature.imp <- FeatureImportance(forest, num.cores = 1L)

}
