% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeSimilarity.R
\name{ComputeSimilarity}
\alias{ComputeSimilarity}
\title{Compute Similarities}
\usage{
ComputeSimilarity(X, forest, num.cores = 0L, Xtrain = NULL)
}
\arguments{
\item{X}{an n sample by d feature matrix (preferable) or data frame which was used to train the provided forest.}

\item{forest}{a forest trained using the rerf function, with COOB=TRUE.}

\item{num.cores}{the number of cores to use while training. If num.cores=0 then 1 less than the number of cores reported by the OS are used. (num.cores=0)}

\item{Xtrain}{an n by d numeric matrix (preferable) or data frame. This should be the same data matrix/frame used to train the forest, and is only required if RerF was called with rank.transform = TRUE. (Xtrain=NULL)}
}
\value{
similarity a normalized n by n matrix of pairwise similarities
}
\description{
Computes pairwise similarities between observations. The similarity between two points is defined as the fraction of trees such that two points fall into the same leaf node.
}
\examples{
library(rerf)
X <- as.matrix(iris[, 1:4])
Y <- iris[[5L]]
forest <- RerF(X, Y, num.cores = 1L)
sim.matrix <- ComputeSimilarity(X, forest, num.cores = 1L)
}
