% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sequent_peak_analysis.R
\name{Rippl}
\alias{Rippl}
\title{Rippl analysis}
\usage{
Rippl(Q, R, double_cycle = FALSE, plot = TRUE)
}
\arguments{
\item{Q}{a time series or vector  of net inflows to the reservoir (volumetric).}

\item{R}{a time series or vector of target releases (volumetric). Must be the same length as Q.}

\item{double_cycle}{logical. If TRUE the Q and R time series will be replicated and placed end-to-end to double the simulation. Recommended if the critical period occurs at the end of the sequence.}

\item{plot}{logical. If TRUE (the default) the storage behavior diagram is plotted.}
}
\value{
Returns the no-fail storage capacity and corresponding storage behaviour time series.
}
\description{
Computes the Rippl no-failure storage for given time series of inflows and releases using the sequent peak algorith.
}
\examples{
# define a release vector for a constant release equal to 70 \% of the mean inflow
release <- rep(mean(ResX_inflow.ts) * 0.7, length(ResX_inflow.ts))
no_fail_storage <- Rippl(ResX_inflow.ts,release)
}
\references{
Rippl, W. (1883) The capacity of storage reservoirs for water supply, In Proceedings of the Institute of Civil Engineers, 71, 270-278.

Thomas H.A., Burden R.P. (1963) Operations research in water quality management. Harvard Water Resources Group, Cambridge

Loucks, D.P., van Beek, E., Stedinger, J.R., Dijkman, J.P.M. and Villars, M.T. (2005) Water resources systems planning and management: An introduction to methods, models and applications. Unesco publishing, Paris, France.
}

