% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simres.R
\name{simRes}
\alias{simRes}
\title{Simulate a water supply reservoir with specified operating policy.}
\usage{
simRes(Q, target, capacity, surface_area, max_depth, evap,
  double_cycle = FALSE, plot = TRUE, S_initial = 1, policy)
}
\arguments{
\item{Q}{vector or time series object. Net inflow totals to the reservoir. Mm^3 (Million cubic meters).}

\item{target}{numerical constant, or a time series or vector of the target releases. Must be the same length as Q is given as a vector or time series. Mm^3 (Million cubic meters).}

\item{capacity}{numerical. The reservoir capacity. Should be same volumetric unit as Q. Mm^3 (Million cubic meters).}

\item{surface_area}{numerical. The reservoir surface area at full capacity. Must be in square kilometers (km^2), or Mm^2.}

\item{max_depth}{numerical. The maximum water depth of the reservoir at maximum capacity. Must be in meters. If omitted, the depth-storage-area relationship will be estimated from surface area and capacity only.}

\item{evap}{vector or time series object of length Q, or a numerical constant.  Evaporation from losses from reservoir surface. Varies with level if depth and surface_area parameters are specified. Recommended units: meters, or kg/m2 * 10 ^ -3.}

\item{double_cycle}{logical. If TRUE the Q and R time series will be replicated and placed end-to-end to double the simulation. Recommended if the critical period occurs at the end of the sequence.}

\item{plot}{logical. If TRUE (the default) the storage and release time series are plotted.}

\item{S_initial}{numerical. The initial storage as a ratio of capacity (0 <= S_initial <= 1). The default value is 1.}

\item{policy}{list. The output of the SDP function. If omitted, Standard Operating Policy is assumed.}
}
\value{
Returns the no-fail storage capacity and corresponding storage behaviour time series.
}
\description{
Simulates a reservoir for a given inflow time series and assuming Standard Operating Policy (meet target at all times, unless constrained by available water in reservoir plus incoming flows) or an optimised policy deived using \code{\link{sdp_supply}}.
}
\examples{
# simulate a reservoir assuming standard operating policy, then compare with SDP-derived policy
#trained on historical flows.

# DEFINE RESERVOIR SPECS AND MODEL INPUTS
res_cap <- 1500 #Mm3
targ <- 150 #Mm3
area <- 40 #km2
max_d <- 40 #m
ev = 0.2 #m
Q_pre1980 <- window(resX$Q_Mm3, end = c(1979, 12), frequency = 12)
Q_post1980 <- window(resX$Q_Mm3, start = c(1980, 1), frequency = 12)

# SIMULATE WITH SOP
layout(1:3)
simSOP <- simRes(Q_post1980, capacity = res_cap, target = targ,
surface_area = area, max_depth = max_d, evap = ev)

# TRAIN SDP POLICY ON HISTORICAL FLOWS
policy_x <- sdp_supply(Q_pre1980, capacity = res_cap, target = targ,
surface_area = area, max_depth = max_d, evap = ev, Markov = TRUE, plot = FALSE)

# SIMULATE WITH SDP-DERIVED POLICY
simSDP <- simRes(Q_post1980, capacity = res_cap, target = targ,
surface_area = area, max_depth = max_d, evap = ev, policy = policy_x)
}

