% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_2x2_perf.R
\name{plot_2x2_perf}
\alias{plot_2x2_perf}
\title{plot_2x2_perf}
\usage{
plot_2x2_perf(
  dfPerf,
  perf_lab = "Median relative error",
  legend_position = "bottom",
  trans = "log10"
)
}
\arguments{
\item{dfPerf}{The performance dataframe which should have the columns : perf, ridge, input_scaling, leaking_rate, spectral_radius. Where perf is the performance metric}

\item{perf_lab}{The label of the performance metric.}

\item{legend_position}{Position of legend passed to ggarrange}

\item{trans}{The transformation (default is "log10")}
}
\value{
A mutliple 2x2 plots.
}
\description{
Plot 2x2 combinations of the hyperparameters.
}
\examples{
dfPerf <-
data.frame(
  perf = runif(n = 10),
  ridge = runif(n = 10),
  input_scaling = runif(n = 10),
  leaking_rate = runif(n = 10)
)
reservoirnet::plot_2x2_perf(dfPerf = dfPerf)


}
