% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv_resp_unit.R
\encoding{UTF-8}
\name{conv_resp_unit}
\alias{conv_resp_unit}
\title{Convert units related to respirometry}
\usage{
conv_resp_unit(value, from, to, temp = 25, sal = 35, atm_pres = 1013.25,
  o2_conc_base = "per_l")
}
\arguments{
\item{value}{a numeric vector giving the measurement value in its original units.}

\item{from, to}{a string defining the unit with subunits separated by " / " or " * ". See Details for proper notation regarding O2 and seawater mass/volume.}

\item{temp}{temperature (°C). Default is 25 °C.}

\item{sal}{salinity (psu). Default is 35 psu.}

\item{atm_pres}{atmospheric pressure (mbar). Default is 1013.25 mbar.}

\item{o2_conc_base}{(optional) if converting between pO2 and [O2], should concentrations be "per_l" or "per_kg"? Default is "per_l".}
}
\description{
Converts units of measurement that are joined by " / " or " * ". This function expands upon \code{\link[measurements]{conv_multiunit}} to incorporate O2 unit conversion and seawater volume-mass conversions.
}
\details{
The O2 units supported by \code{\link{conv_o2}} should be appended with "_O2" (e.g. "kPa_O2"; even "percent_o2_O2") and O2 unit concentrations should drop "per_l" or "per_kg" (e.g. "umol_O2"). To designate seawater mass-volume conversion, append the unit with "_seawater" (e.g. "kg_seawater").
}
\examples{
# I read that an animal's MO2 is 1.92 ml O2/kg/min. What is this MO2 in umol O2/g/h?
conv_resp_unit(value = 1.92, from = "ml_O2 / kg / min", to = "umol_O2 / g / hr")

# Krogh's diffusion coefficient for oxygen through gills can be expressed as ml O2 / mm2 (gill
# surface area) / um (gill thickness) / torr (seawater pO2 - blood pO2) / minute at a given
# temperature.
# To convert to another unit:
conv_resp_unit(value = 1e-6, from = "ml_O2 / mm2 / um / torr / min",
to = "umol_O2 / cm2 / um / kPa / hr", temp = 20)

# Now, with a knowledge of gill morphometrics, seawater pO2, and blood pO2, I can compare
# gill diffusion with whole animal MO2.

}
\seealso{
\code{\link[measurements]{conv_multiunit}}, \code{\link{conv_o2}}, \code{\link[seacarb]{rho}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
