% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ListingCreation.r
\name{generateListing}
\alias{generateListing}
\title{generateListing}
\usage{
generateListing(data, bullets, type = "Job", specialChars = "&")
}
\arguments{
\item{data}{data.frame holding the info for one job}

\item{bullets}{The BulletName's for the desired rows}

\item{type}{The type of subsection to build; defaults to 'Job', the other currently supported value is 'Research'}

\item{specialChars}{Vector of characters that need to be double-backslashed escaped}
}
\value{
LaTeX code for a subsection in the resume
}
\description{
Generate LaTeX code for job info
}
\details{
Given a subsetted dataset of just one job this generates LaTeX code.  Given jobname and company name, print out the section.
}
\examples{
library(dplyr)

jobs <- read.csv(system.file('examples/Jobs.csv', package='resumer'))
oneJob <- jobs \%>\% filter(Company=='Pied Piper', JobName=='Tech Startup')
generateListing(oneJob)
generateListing(oneJob, bullets=c(1, 3))

oneResearch <- jobs \%>\% filter(JobName=='Oddie Research', Company=='Hudson University')
generateListing(oneResearch, bullets=4, type='Research')
generateListing(oneResearch, bullets=4:5, type='Research')

}
\seealso{
\code{\link{generateMultipleListings}} \code{\link{generateSection}}
}
\author{
Jared P. Lander
}
