% Generated by roxygen2 (4.0.2): do not edit by hand
\name{idt.read.dataset}
\alias{idt.read.dataset}
\title{Read one of the Thompson lab's retinal datasets}
\usage{
idt.read.dataset(dataset, d.close = 0.25)
}
\arguments{
\item{dataset}{Path to directory containing as SYS and MAP file}

\item{d.close}{Maximum distance between points for them to count
as the same point. This is expressed as a fraction of the width of
the outline.}
}
\value{
\item{dataset}{The path to the directory given as an argument}
\item{raw}{List containing\describe{
   \item{\code{map}}{The raw MAP data}
   \item{\code{sys}}{The raw SYS data}
}}
\item{P}{The points of the outline}
\item{gf}{Forward pointers along the outline}
\item{gb}{Backward pointers along the outline}
\item{Ds}{List of datapoints}
\item{Ss}{List of landmark lines}
}
\description{
Read one of the Thompson lab's retinal datasets. Each dataset is a
folder containing a SYS file in SYSTAT format and a MAP file in
text format. The SYS file specifies the locations of the data
points and the MAP file specifies the outline.
}
\details{
The function returns the outline of the retina. In order to do so,
it has to join up the segments of the MAP file. The tracings are
not always precise; sometimes there are gaps between points that
are actually the same point. The parameter \code{d.close} specifies
how close points must be to count as the same point.
}
\author{
David Sterratt
}

