% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_diagnostics.R
\name{plot.evpost}
\alias{plot.evpost}
\title{Plot diagnostics for an evpost object}
\usage{
\method{plot}{evpost}(x, y, ..., n = ifelse(x$d == 1, 1001, 101),
  prob = c(0.1, 0.25, 0.5, 0.75, 0.95, 0.99), ru_scale = FALSE,
  rows = NULL, xlabs = NULL, ylabs = NULL)
}
\arguments{
\item{x}{an object of class "evpost", a result of a call to
\code{\link{rpost}}.}

\item{y}{Not used.}

\item{...}{Additional arguments passed on to \code{hist}, \code{lines},
\code{contour} or \code{points}.}

\item{n}{A number.  The meaning depends on the value of x$d.
\itemize{
  \item {For d = 1 : n + 1 is the number of abscissae in the trapezium
     method used to normalize the density.}
  \item {For d = 2 : an n by n regular grid is used to contour the density.}
}}

\item{prob}{Numeric vector. Only relevant for d = 2.  The contour lines are
drawn such that the respective probabilities that the variable lies
within the contour are approximately prob.}

\item{ru_scale}{A logical scalar.  Should we plot data and density on the
scale used in the ratio-of-uniforms algorithm (TRUE) or on the original
scale (FALSE)?}

\item{rows}{A numeric scalar.  When \code{d} > 2 this sets the number of
rows of plots.  If the user doesn't provide this then it is set
internally.}

\item{xlabs, ylabs}{Numeric vectors.  When \code{d} > 2 these set the labels
on the x and y axes respectively.  if the use doesn't provide these then
the column names of the simulated data matrix to be plotted are used.}
}
\description{
\code{plot} method for class "evpost".  For \code{d = 1} a histogram of the
  simulated values is plotted with a the density function superimposed.
  The density is normalized crudely using the trapezium rule.  For
  \code{d = 2} a scatter plot of the simulated values is produced with
  density contours superimposed.  For \code{d > 2} pairwise plots of the
  simulated values are produced using \code{pairs()}.
}
\details{
Note that \code{suppressWarnings} is used to avoid potential benign warnings
  caused by passing unused graphical parameters to \code{hist} and
  \code{lines} via \code{...}.
}
\examples{
# GP posterior
data(gom)
u <- stats::quantile(gom, probs = 0.65)
fp <- set_prior(prior = "flat", model = "gp", min_xi = -1)
gpg <- rpost(n = 1000, model = "gp", prior = fp, thresh = u, data = gom)
plot(gpg)

}
\seealso{
\code{\link{summary.evpost}} for summaries of the simulated values
  and properties of the ratio-of-uniforms algorithm.
}

