% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{gp}
\alias{gp}
\alias{dgp}
\alias{pgp}
\alias{qgp}
\alias{rgp}
\title{The Generalised Pareto Distribution}
\usage{
dgp(x, loc = 0, scale = 1, shape = 0, log = FALSE)

pgp(q, loc = 0, scale = 1, shape = 0, lower.tail = TRUE,
  log.p = FALSE)

qgp(p, loc = 0, scale = 1, shape = 0, lower.tail = TRUE,
  log.p = FALSE)

rgp(n, loc = 0, scale = 1, shape = 0)
}
\arguments{
\item{x, q}{Numeric vectors of quantiles.  All elements of \code{x}
and \code{q} must be non-negative.}

\item{loc, scale, shape}{Numeric vectors.
Location, scale and shape parameters.
All elements of \code{scale} must be positive.}

\item{log, log.p}{A logical scalar; if TRUE, probabilities p are given as
log(p).}

\item{lower.tail}{A logical scalar.  If TRUE (default), probabilities
are P[X <= x], otherwise, P[X > x].}

\item{p}{A numeric vector of probabilities in [0,1].}

\item{n}{Numeric scalar.  The number of observations to be simulated.
If \code{length(n) > 1} then \code{length(n)} is taken to be the number
required.}
}
\value{
\code{dgp} gives the density function, \code{pgp} gives the
  distribution function, \code{qgp} gives the quantile function,
  and \code{rgp} generates random deviates.
}
\description{
Density function, distribution function, quantile function and
random generation for the generalised Pareto (GP) distribution.
}
\details{
The distribution function of a GP distribution with parameters
 \code{location} = \eqn{\mu}, \code{scale} = \eqn{\sigma} (>0) and
 \code{shape} = \eqn{\xi} is
 \deqn{F(x) = 1 - [1 + \xi (x - \mu) / \sigma] ^ (-1/\xi) }
 for \eqn{1 + \xi (x - \mu) / \sigma > 0}.  If \eqn{\xi = 0} the
 distribution function is defined as the limit as \eqn{\xi} tends to zero.
 The support of the distribution depends on \eqn{\xi}: it is
 \eqn{x >= \mu} for \eqn{\xi >= 0};
 and \eqn{\mu <= x <= \mu - \sigma / \xi} for \eqn{\xi < 0}.  Note that
 if \eqn{\xi < -1} the GP density function becomes infinite as \eqn{x}
 approaches \eqn{\mu - \sigma/\xi}.

 If \code{lower.tail = TRUE} then if \code{p = 0} (\code{p = 1}) then
 the lower (upper) limit of the distribution is returned.
 The upper limit is \code{Inf} if \code{shape} is non-negative.
 Similarly, but reversed, if \code{lower.tail = FALSE}.

 See
 \url{https://en.wikipedia.org/wiki/Generalized_Pareto_distribution}
  for further information.
}
\examples{
dgp(0:4, scale = 0.5, shape = 0.8)
dgp(1:6, scale = 0.5, shape = -0.2, log = TRUE)
dgp(1, scale = 1, shape = c(-0.2, 0.4))

pgp(0:4, scale = 0.5, shape = 0.8)
pgp(1:6, scale = 0.5, shape = -0.2)
pgp(1, scale = c(1, 2), shape = c(-0.2, 0.4))
pgp(7, scale = 1, shape = c(-0.2, 0.4))

qgp((0:9)/10, scale = 0.5, shape = 0.8)
qgp(0.5, scale = c(0.5, 1), shape = c(-0.5, 0.5))

p <- (1:9)/10
pgp(qgp(p, scale = 2, shape = 0.8), scale = 2, shape = 0.8)

rgp(6, scale = 0.5, shape = 0.8)
}
\references{
Pickands, J. (1975) Statistical inference using extreme
  order statistics. \emph{Annals of Statistics}, \strong{3}, 119-131.
  \url{http://dx.doi.org/10.1214/aos/1176343003}

Coles, S. G. (2001) \emph{An Introduction to Statistical
  Modeling of Extreme Values}, Springer-Verlag, London.
  Chapter 4: \url{http://dx.doi.org/10.1007/978-1-4471-3675-0_4}
}
