% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{distribution}
\alias{distribution}
\title{distribution}
\usage{
distribution(species_list = NULL, fields = NULL, server = NULL, ...)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, a table for all fish will be returned.}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned.  Mostly for backwards compatibility as users can subset by column later}

\item{server}{can be set to either "fishbase" or "sealifebase" to switch between databases. NOTE: it is usually
easier to leave this as NULL and set the source instead using the environmental variable `FISHBASE_API`, e.g.
`Sys.setenv(FISHBASE_API="sealifebase")`.}

\item{...}{unused; for backwards compatibility only}
}
\description{
return a table of species locations as reported in FishBASE.org FAO location data
}
\details{
currently this is ~ FAO areas table (minus "note" field)
e.g. http://www.fishbase.us/Country/FaoAreaList.php?ID=5537
}
\examples{
\dontrun{
distribution(species_list(Genus='Labroides'))
}
}
