/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace;

import java.io.Closeable;
import java.util.List;
import javax.swing.JFrame;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.propagation.PropagationEngineObserver;
import org.chocosolver.solver.propagation.PropagationObserver;
import org.chocosolver.solver.propagation.PropagationProfiler;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.trace.GephiGenerator;
import org.chocosolver.solver.trace.GephiNetwork;
import org.chocosolver.solver.trace.GraphvizGenerator;
import org.chocosolver.solver.trace.IMessage;
import org.chocosolver.solver.trace.LogStatEveryXXms;
import org.chocosolver.solver.trace.VerboseSolving;
import org.chocosolver.solver.trace.frames.StatisticsPanel;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.StringUtils;

public interface IOutputFactory
extends ISelf<Solver> {
    public static final String WELCOME_MESSAGE = "** Choco 4.10.9 (2022-08) : Constraint Programming Solver, Copyright (c) 2010-2022";

    default public void printVersion() {
        ((Solver)this.ref()).log().bold().blue().println(WELCOME_MESSAGE);
    }

    default public void printFeatures() {
        ((Solver)this.ref()).getMeasures().setReadingTimeCount(System.nanoTime() - ((Solver)this.ref()).getModel().getCreationTime());
        ((Solver)this.ref()).log().printf("- Model[%s] features:\n", ((Solver)this.ref()).getModel().getName());
        ((Solver)this.ref()).log().printf("\tVariables : %d\n", ((Solver)this.ref()).getModel().getNbVars());
        ((Solver)this.ref()).log().printf("\tConstraints : %d\n", ((Solver)this.ref()).getModel().getNbCstrs());
        ((Solver)this.ref()).log().printf("\tBuilding time : %.3fs\n", Float.valueOf(((Solver)this.ref()).getMeasures().getReadingTimeCount()));
        ((Solver)this.ref()).log().printf("\tUser-defined search strategy : %s\n", ((Solver)this.ref()).getModel().getSolver().isDefaultSearchUsed() ? "no" : "yes");
        ((Solver)this.ref()).log().printf("\tComplementary search strategy : %s\n", ((Solver)this.ref()).isSearchCompleted() ? "yes" : "no");
    }

    default public void printShortFeatures() {
        ((Solver)this.ref()).getMeasures().setReadingTimeCount(System.nanoTime() - ((Solver)this.ref()).getModel().getCreationTime());
        String st = "Model[" + ((Solver)this.ref()).getModelName() + "], " + String.format("%d variables, %d constraints, building time: %.3fs, %s user-defined search strategy, %s complementary search strategy", ((Solver)this.ref()).getModel().getNbVars(), ((Solver)this.ref()).getModel().getNbCstrs(), Float.valueOf(((Solver)this.ref()).getMeasures().getReadingTimeCount()), ((Solver)this.ref()).getModel().getSolver().isDefaultSearchUsed() ? "w/" : "w/o", ((Solver)this.ref()).isSearchCompleted() ? "w/" : "w/o");
        ((Solver)this.ref()).log().bold().println(st);
    }

    default public void printStatistics() {
        this.printVersion();
        this.printFeatures();
        ((Solver)this.ref()).log().println(((Solver)this.ref()).getMeasures().toString());
    }

    default public void printShortStatistics() {
        ((Solver)this.ref()).log().println(((Solver)this.ref()).getMeasures().toOneLineString());
    }

    default public void printCSVStatistics() {
        ((Solver)this.ref()).log().println(((Solver)this.ref()).getMeasures().toCSV());
    }

    default public void showStatistics() {
        ((Solver)this.ref()).plugMonitor(new IMonitorInitialize(){

            @Override
            public void beforeInitialize() {
                IOutputFactory.this.printVersion();
                IOutputFactory.this.printFeatures();
            }
        });
        ((Solver)this.ref()).plugMonitor(new IMonitorClose(){

            @Override
            public void afterClose() {
                ((Solver)IOutputFactory.this.ref()).log().println(((Solver)IOutputFactory.this.ref()).getMeasures().toString());
            }
        });
    }

    default public void showShortStatistics() {
        ((Solver)this.ref()).plugMonitor(new IMonitorClose(){

            @Override
            public void beforeClose() {
                IOutputFactory.this.printShortStatistics();
            }
        });
    }

    default public void showShortStatisticsOnShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((Solver)this.ref()).printShortStatistics()));
    }

    default public void showSolutions(IMessage message) {
        ((Solver)this.ref()).plugMonitor(() -> ((Solver)this.ref()).log().println(message.print()));
    }

    default public void showSolutions() {
        this.showSolutions(new DefaultSolutionMessage((Solver)this.ref()));
    }

    default public void showDecisions(final IMessage message) {
        ((Solver)this.ref()).plugMonitor(new IMonitorDownBranch(){

            @Override
            public void beforeDownBranch(boolean left) {
                ((Solver)IOutputFactory.this.ref()).log().printf("%s %s ", StringUtils.pad("", ((Solver)IOutputFactory.this.ref()).getEnvironment().getWorldIndex(), "."), ((Solver)IOutputFactory.this.ref()).getDecisionPath().lastDecisionToString());
                ((Solver)IOutputFactory.this.ref()).log().printf(" // %s \n", message.print());
            }
        });
    }

    default public void showDecisions() {
        this.showDecisions(new DefaultDecisionMessage((Solver)this.ref()));
    }

    default public void showContradiction() {
        ((Solver)this.ref()).plugMonitor(cex -> ((Solver)this.ref()).log().red().println(String.format("\t/!\\ %s", cex.toString())));
    }

    default public void showStatisticsDuringResolution(long f) {
        if (f > 0L) {
            ((Solver)this.ref()).plugMonitor(new LogStatEveryXXms((Solver)this.ref(), f));
        }
    }

    default public void verboseSolving(long frequencyInMilliseconds) {
        ((Solver)this.ref()).plugMonitor(new VerboseSolving((Solver)this.ref(), frequencyInMilliseconds));
    }

    default public void showDashboard() {
        this.showDashboard(100L);
    }

    default public void showDashboard(long refresh) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("Dashboard");
        frame.setDefaultCloseOperation(3);
        StatisticsPanel newContentPane = new StatisticsPanel((Solver)this.ref(), refresh, frame);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    default public void observePropagation(PropagationObserver po) {
        ((Solver)this.ref()).setEngine(new PropagationEngineObserver(((Solver)this.ref()).getModel(), po));
    }

    default public PropagationProfiler profilePropagation() {
        PropagationProfiler po = new PropagationProfiler(((Solver)this.ref()).getModel());
        ((Solver)this.ref()).observePropagation(po);
        return po;
    }

    default public Closeable outputSearchTreeToGraphviz(String gvFilename) {
        return new GraphvizGenerator(gvFilename, (Solver)this.ref());
    }

    default public Closeable outputSearchTreeToGephi(String gexfFilename) {
        return new GephiGenerator(gexfFilename, (Solver)this.ref());
    }

    @Deprecated
    default public Closeable outputSearchTreeToCPProfiler(boolean domain) {
        return null;
    }

    default public void constraintNetworkToGephi(String gexfFilename) {
        GephiNetwork.write(gexfFilename, ((Solver)this.ref()).getModel());
    }

    default public double[][] buildDistanceMatrix(List<Solution> solutions, int p) {
        int n = solutions.size();
        IntVar[] vars = solutions.get(0).retrieveIntVars(true).toArray(new IntVar[0]);
        double[][] m = new double[n][n];
        for (int i = 0; i < n; ++i) {
            Solution soli = solutions.get(i);
            for (int j = i + 1; j < n; ++j) {
                Solution solj = solutions.get(j);
                double d = 0.0;
                for (int k = 0; k < vars.length; ++k) {
                    double a2 = Math.abs(soli.getIntVal(vars[k]) - solj.getIntVal(vars[k]));
                    d += Math.pow(a2, p);
                }
                double d2 = Math.pow(d, 1.0 / (double)p);
                m[j][i] = d2;
                m[i][j] = d2;
            }
        }
        return m;
    }

    default public double[][] buildDifferenceMatrix(List<Solution> solutions) {
        int n = solutions.size();
        IntVar[] vars = solutions.get(0).retrieveIntVars(true).toArray(new IntVar[0]);
        double[][] m = new double[n][n];
        for (int i = 0; i < n; ++i) {
            Solution soli = solutions.get(i);
            for (int j = i + 1; j < n; ++j) {
                Solution solj = solutions.get(j);
                double d = 0.0;
                for (int k = 0; k < vars.length; ++k) {
                    d += soli.getIntVal(vars[k]) == solj.getIntVal(vars[k]) ? 0.0 : 1.0;
                }
                double d2 = d / (double)vars.length;
                m[j][i] = d2;
                m[i][j] = d2;
            }
        }
        return m;
    }

    public static class DefaultDecisionMessage
    implements IMessage {
        private final Solver solver;

        public DefaultDecisionMessage(Solver solver) {
            this.solver = solver;
        }

        @Override
        public String print() {
            int limit = 120;
            Variable[] vars = this.solver.getSearch().getVariables();
            StringBuilder s = new StringBuilder(32);
            for (int i = 0; i < vars.length && s.length() < limit; ++i) {
                s.append(vars[i]).append(' ');
            }
            if (s.length() >= limit) {
                s.append("...");
            }
            return s.toString();
        }
    }

    public static class DefaultSolutionMessage
    implements IMessage {
        private final Solver solver;

        public DefaultSolutionMessage(Solver solver) {
            this.solver = solver;
        }

        @Override
        public String print() {
            return String.format("- Solution #%s found. %s \n\t%s.", this.solver.getSolutionCount(), this.solver.getMeasures().toOneLineString(), this.print(this.solver.getSearch().getVariables()));
        }

        private String print(Variable[] vars) {
            StringBuilder s = new StringBuilder(32);
            for (Variable v : vars) {
                s.append(v).append(' ');
            }
            return s.toString();
        }
    }
}

