% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_order.R
\name{add_order}
\alias{add_order}
\alias{place_order}
\alias{post_order}
\title{Create a New Order For A Currency}
\usage{
add_order(api.key, secret, passphrase, product_id = "LTC-USD",
  type = "limit", side = "b", price, size)
}
\arguments{
\item{api.key}{Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.}

\item{secret}{Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.}

\item{passphrase}{Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.}

\item{product_id}{Optional character value for the currency pair. The default is \code{"LTC-USD"}. This param is case insensitive and must be one of the valid currency-pair. The list of valid currency-pairs can be fetched using \code{\link{public_info}}.}

\item{type}{Optional character value for the order type. The default is \code{"limit"}. This param is case insensitive and must be one of the valid order types. The current valid order types is only \code{"limit"}.}

\item{side}{Optional character value for the order side The default is \code{"b"} which stands for \code{buy}. This param is case insensitive and must be one of either \code{"b"} (buy) or \code{"s"} (sell).}

\item{price}{Mandatory numeric value. It can either be an integer or float. Float values of greater than 2 decimals will be rounded to 2 decimals using the generic \code{round} function from R.}

\item{size}{Mandatory numeric value. It can either be an integer or float. Float values will \bold{NOT} be rounded. The user must ensure that the fractional unit of a currency pair is valid for acceptance by GDAX. This information can also be determined by \code{\link{public_info}} which provides the minimun and maximum order sizes for each currency pairs.}
}
\value{
Dataframe with status of the order, posted details and created time stamp etc.
}
\description{
This is an auth based function. User must have valid api keys generated by GADX which must be passed as mandatory arguments. The users can place different types of orders like \code{"limit"}, \code{"stop"} or \code{"market"}. Orders will be placed succesfully only if there is sufficient funds. Each order will result in a hold and the details of the hold can be tracked using \code{\link{holds}}. Margin Orders and Stop Orders are currently not supported.
}
\examples{
\dontrun{
add_order("BTC-USD", api.key = your_key, secret = your_api_secret, passphrase = your_api_pass,
     type="limit", side = "sell", price = 1000.25, size = 1)
}

}
