% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_candles.R
\name{public_candles}
\alias{public_candles}
\title{Get bids and asks for provided currency-pair (products) by GDAX.}
\usage{
public_candles(product_id = "LTC-USD", start = NULL, end = NULL,
  granularity = NULL)
}
\arguments{
\item{product_id}{Optional character parameter. This is a case insensitive value of the product id for which the order book is desired. Default to \code{'LTC-USD'}. For all valid product ids, refer to \code{\link{public_info}}.}

\item{start}{Optional parameter. Start time in ISO 8601}

\item{end}{Optional parameter. End time in ISO 8601}

\item{granularity}{Optional parameter. Desired timeslice in seconds.}
}
\value{
Dataframe with a time of the candle, low, high, open , close and volume for that candle.
}
\description{
This function is a public function and will fetch all bids/asks for provided currency pair (product_id). User should change the level to get the best bid/ask or to fetch all bids/asks.
}
\examples{
\dontrun{
public_candles()
public_candles("ETH-EUR")
}

}
