% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{azp_greedy}
\alias{azp_greedy}
\title{A greedy algorithm to solve the AZP problem}
\usage{
azp_greedy(
  p,
  w,
  data,
  bound_vals = vector("numeric"),
  min_bound = 0,
  inits = 0,
  initial_regions = vector("numeric"),
  distance_method = "euclidean",
  random_seed = 123456789
)
}
\arguments{
\item{p}{The number of spatially constrained clusters}

\item{w}{An instance of Weight class}

\item{data}{A list of numeric vectors of selected variable}

\item{bound_vals}{(optional) A numeric vector of selected bounding variable}

\item{min_bound}{(optional) A minimum value that the sum value of bounding variable int each cluster should be greater than}

\item{inits}{(optional) The number of construction re-runs, which is for ARiSeL "automatic regionalization with initial seed location"}

\item{initial_regions}{(optional) The initial regions that the local search starts with. Default is empty. means the local search starts with a random process to "grow" clusters}

\item{distance_method}{(optional) The distance method used to compute the distance betwen observation i and j. Defaults to "euclidean". Options are "euclidean" and "manhattan"}

\item{random_seed}{(optional) The seed for random number generator. Defaults to 123456789.}
}
\value{
A list of numeric vectors represents a group of clusters
}
\description{
The automatic zoning procedure (AZP) was initially outlined in Openshaw (1977) as a way to address some of the consequences of the modifiable areal unit problem (MAUP). In essence, it consists of a heuristic to find the best set of combinations of contiguous spatial units into p regions, minimizing the within sum of squares as a criterion of homogeneity. The number of regions needs to be specified beforehand.
}
\examples{
\dontrun{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
queen_w <- queen_weights(guerry)
guerry_df <- as.data.frame(guerry) # use as data.frame
data <- guerry_df[c('Crm_prs','Crm_prp','Litercy','Donatns','Infants','Suicids')]
azp_clusters <- azp_greedy(5, queen_w, data)
azp_clusters
}
}
