% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{local_bijoincount}
\alias{local_bijoincount}
\title{Local Bivariate Join Count Statistics}
\usage{
local_bijoincount(
  w,
  data1,
  data2,
  permutations = 999,
  significance_cutoff = 0.05,
  cpu_threads = 6,
  seed = 123456789
)
}
\arguments{
\item{w}{An instance of Weight object}

\item{data1}{A numeric array of selected variable}

\item{data2}{A numeric array of selected variable}

\item{permutations}{The number of permutations for the LISA computation}

\item{significance_cutoff}{A cutoff value for significance p-values to filter not-significant clusters}

\item{cpu_threads}{The number of cpu threads used for parallel LISA computation}

\item{seed}{The seed for random number generator}
}
\value{
An instance of LISA-class
}
\description{
The function to apply local Bivariate Join Count statistics
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
queen_w <- queen_weights(guerry)
guerry_df <- as.data.frame(guerry) # use as data.frame
top_crm <- guerry_df['TopCrm'][,1]
inv_crm <-  1 - top_crm
lisa <- local_bijoincount(queen_w, top_crm, inv_crm)
clsts<- lisa_clusters(lisa)
clsts
}
