% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_graph6.R
\name{is_graph6}
\alias{is_graph6}
\alias{is_sparse6}
\alias{is_digraph6}
\alias{guess_format}
\title{Infer or test for graph6, sparse6, and digraph6 symbols}
\usage{
is_graph6(x)

is_sparse6(x)

is_digraph6(x)

guess_format(x)
}
\arguments{
\item{x}{character vector}
}
\value{
Logical vector of length equal to \code{length(x)} with \code{TRUE} if an
element is a valid symbol and \code{FALSE} otherwise.

Function \code{\link[=guess_format]{guess_format()}} returns a character vector of the same
length as \code{x} with values "graph6", "sparse6", or "digraph6" depending on
the type of symbol present, or \code{NA} if the symbol is unknown or matches
more than one type.
}
\description{
Functions \code{\link[=is_graph6]{is_graph6()}}, \code{\link[=is_sparse6]{is_sparse6()}}), and \code{\link[=is_digraph6]{is_digraph6()}} test if elements
of a character vector are valid symbols of particular type.

Function \code{\link[=guess_format]{guess_format()}} tries to guess the type of the symbols
used in \code{x}.
}
\note{
At this moment the test is performed using regular expressions.
Theoretically it may result in false positives.
}
\examples{
all(is_graph6(g6))
all(is_sparse6(s6))
all(is_digraph6(d6))

# Vector mixing graphs in various formats
x <- g6
x[seq(2, 20, by = 3)] <- s6[seq(2, 20, by = 3)]
x[seq(3, 20, by = 3)] <- d6[seq(3, 20, by = 3)]
guess_format(x)
}
