###
# Get Handset
#
# This function is to get a handset of a set and calculate the kappa
# @param set This is the set to take a handset of
# @param handSetLength This is the length of the handset to take
# @param handSetBaserate This is the minimum baserate to inflate the handset to
# @param returnSet If TRUE, then return the handSet if FALSE, return the kappa of the handSet
# @keywords handset, hand, inflation
# @return The function returns the handSet if returnSet is TRUE or the kappa of the handSet if not
###
getHandSet = function(set, handSetLength, handSetBaserate, returnSet=FALSE) {
  #positives is the minimum number of positive pairs in the first rater
  positives = ceiling(handSetLength * handSetBaserate);
  handSetKappa = NaN;
  if(positives > length(which(set[,1] == 1))){stop("Not enough positives in first rater to inflate to this level")}
  #if there is an inflated baserate positives will be > 0, so if handSetBaserate > 0, positives > 0
  if (positives > 0) {
    #goes through and picks a set that fits the number of positives first then randomly samples from the rest
    #if the set created is not a valid set, then it reruns the process until a valid set is found
    while(is.nan(handSetKappa)) {
      tp = set[which(set[,1] == 1),];
      positiveIndices = sample(1:nrow(tp),size=positives,replace=FALSE);
      others = set[setdiff(1:nrow(set),positiveIndices),];
      otherIndices = sample(1:nrow(others),size=(handSetLength - positives),replace=FALSE);
      handSet = rbind(tp[positiveIndices,],others[otherIndices,]);
      handSetKappa = calcKappa(handSet);
      #ORIGINAL CODE BEFORE THE SWITCH TO TOTAL RANDOM POST POSITIVE SAMPLING - BJR 10/10/16
      #tp = set[which(set[,1] == 1),];
      #positiveIndices = sample(1:nrow(tp),size=positives,replace=FALSE);
      #others = set[which(set[,1] == 0),];
      #otherIndices = sample(1:nrow(others),size=(handSetLength - positives),replace=FALSE);
      #handSet = rbind(tp[positiveIndices,],others[otherIndices,]);
      #handSetKappa = calcKappa(handSet);
    }
  } else if (positives == 0){
    #if there is no restriction on positives, then the set is generated by randomly sampling from the entire set
    handSet=matrix(0,2,2);
    while (is.nan(handSetKappa) & (sum(handSet[,2]) == 0 | sum(handSet[,2]) == nrow(handSet))) {
      theseIndices = sample(1:nrow(set),size=handSetLength,replace=FALSE);
      handSet = set[theseIndices,];
      handSetKappa = calcKappa(handSet);
    }
  }

  #if the set generation still fails, print results and exit
  if(is.nan(handSetKappa)) {
    print(handSetLength);
    print(handSetBaserate);
    #View(handSet);
  }

  #if return set is true return set rather than kappa
  if(returnSet){
    return(handSet);
  }

  #otherwise return the kappa of the set
  return(handSetKappa);
};
