\name{summary.ridgeLogistic}
\alias{summary.ridgeLogistic}
\alias{print.summary.ridgeLogistic}

\title{
  \code{summary} method for class \code{ridgeLogistic}
}
\description{
  \code{summary} method for class \code{ridgeLogistic}, with control
  over how much information to print. 
}
\usage{

\method{summary}{ridgeLogistic}(object, all.coef = FALSE, ...)

\method{print}{summary.ridgeLogistic}(x, digits = max(3, getOption("digits") - 3),
    signif.stars = getOption("show.signif.stars"), ...) 
}

\arguments{
  \item{object}{
    A \code{ridgeLogistic} object, typically generated by a call to \code{logisticRidge}.
  }
  \item{all.coef}{
    Logical. Should results be returned for all ridge regression penalty
    paramters (\code{all.coef = TRUE}) or only for the ridge parameter
    chosen automatically? 
  }
  \item{x}{
    A \code{summary.ridgeLogistic} object, typically generated by a call to
    \code{summary.ridgeLogistic}. 
  }
  \item{digits}{
    Minimum number of significant digits to be used for most numbers.
  }
  \item{signif.stars}{
    Logical. If \code{TRUE}, P-values are additionally encoded
    visually as \code{significance stars} in order to help scanning of
    long coefficient tables.  It defaults to the
    \code{show.signif.stars} slot of \code{options}.
  }
  \item{\dots}{
    Additional arguments to be passed to or from other methods. 
  }
}
\details{
  If \code{logisticRidge} was called with \code{lambda = "automatic"}
  then \code{summary.ridgeLogistic} will only print the summary of the
  regression coefficients computed using the ridge parameter chosen
  automatically. To print the
  regression coefficients for all values of the shrinkage parameter, use
   \code{all.coef = TRUE}.
  Otherwise, all the coefficients are printed.
}
\value{
  The function \code{summary.ridgeLogisitc} computes and returns a list of
  summary information from the fitted logistic ridge regression model given
  in \code{object}. The \code{summary.ridgeLogisitc} object is a list
  with the following components:
  \item{automatic }{Logical, taken from \code{object}}
  \item{call }{The function call, taken from \code{object}}
  \item{lambda }{Numeric vector of one or more ridge regression
    parameters, taken from \code{object}}
  \item{all.coef }{Logical}
  Optionally the element
  \item{chosen.nPCs }{The number of principal components used to compute
    the ridge regression parameter chosen automatically.}
  
  \item{summaries }{A list of the same length as the length of
    \code{lambda}, containing summaries of each ridge regression fit. }
  Each element of \code{summaries} is itself a list, with the following
  components:
  \itemize{
    \item \code{coefficients}: A table of regression parameter estimates, were
    appropriate their scaled counterparts, their standard errors, \emph{t}
    statistics and \emph{p}-values according to the test of Cule \emph{et al}. 
    \item \code{df}: A vector containing the effective degrees of freedom for
    the model and the effective degrees of freedom for variance.
    \item \code{lambda}: The shrinkage parameter used to compute the regression coefficients.
    \item \code{nPCs} (optional): The number of principal components used to
    compute the shrinkage parameter.
  }
}
\references{
  Significance testing in ridge regression for genetic data.
  Cule, E. \emph{et al} (2011) BMC Bioinformatics, 12:372

  A semi-automatic method to guide the choice of ridge parameter in ridge
  regression. Cule, E. and De Iorio, M. (2012) arXiv:1205.0686v1
}
\author{
  Erika Cule
}

\seealso{
  \code{\link{logisticRidge}}
}
\examples{
data(GenBin)
mod <- logisticRidge(Phenotypes ~ ., data = as.data.frame(GenBin))
sumMod <- summary(mod, all.coef = TRUE)
sumMod
}

