## ----echo = FALSE, results = "hide"--------------------------------------
knitr::opts_chunk$set(
  error = FALSE,
  fig.width = 7,
  fig.height = 5)
set.seed(1)

## ------------------------------------------------------------------------
buf <- ring::ring_buffer_env(100)

## ------------------------------------------------------------------------
buf

## ------------------------------------------------------------------------
buf$size()

## ------------------------------------------------------------------------
buf$free()
buf$used()

## ------------------------------------------------------------------------
buf$is_empty()
buf$is_full()

## ------------------------------------------------------------------------
buf$push(letters[1:5])

## ------------------------------------------------------------------------
buf$is_empty()

## ------------------------------------------------------------------------
buf$used()

## ------------------------------------------------------------------------
buf$free()

## ------------------------------------------------------------------------
buf$read(1)
buf$read(2)

## ----error = TRUE--------------------------------------------------------
buf$read(20)

## ------------------------------------------------------------------------
buf$tail()

## ------------------------------------------------------------------------
buf$head()

## ------------------------------------------------------------------------
buf$tail_offset(1)

## ------------------------------------------------------------------------
buf$head_offset(3)

## ------------------------------------------------------------------------
buf$free()
buf$take(1)
buf$free()

## ------------------------------------------------------------------------
buf$tail()

## ------------------------------------------------------------------------
buf$reset()
buf$used()
buf$is_empty()

## ------------------------------------------------------------------------
buf$size()
buf$grow(20)
buf$size()

## ------------------------------------------------------------------------
step <- function(x) {
  if (runif(1) < 0.5) x - 1L else x + 1L
}

x <- 0L
buf <- ring::ring_buffer_env(5)
h <- integer(20)
buf$push(x)
h[1L] <- x

set.seed(1)
for (i in seq_len(length(h) - 1L)) {
  x <- step(x)
  buf$push(x)
  h[i + 1L] <- x
}

## ------------------------------------------------------------------------
h

## ------------------------------------------------------------------------
unlist(buf$read(5))

## ------------------------------------------------------------------------
step <- function(x) {
  if (length(x) > 1) {
    p <- mean(diff(x)) / 2 + 0.5
  } else {
    p <- 0.5
  }
  if (runif(1) < p) x[length(x)] - 1L else x[length(x)] + 1L
}

x <- 0L
buf <- ring::ring_buffer_env(5)
h <- integer(100)
buf$push(x)
h[1L] <- x

set.seed(1)
for (i in seq_len(length(h) - 1L)) {
  x <- step(unlist(buf$read(buf$used())))
  buf$push(x)
  h[i + 1L] <- x
}

## ------------------------------------------------------------------------
par(mar = c(4, 4, .5, .5))
plot(h, type = "l", xlab = "step", ylab = "y", las = 1)

## ------------------------------------------------------------------------
buf <- ring::ring_buffer_bytes(1000)

## ------------------------------------------------------------------------
buf$free()
buf$used()
buf$is_full()
buf$is_empty()

## ------------------------------------------------------------------------
bytes <- as.raw(0:255)

## ------------------------------------------------------------------------
buf$push(bytes)

## ------------------------------------------------------------------------
buf$read(10)

## ------------------------------------------------------------------------
buf$used()
buf$take(20)
buf$used()

## ------------------------------------------------------------------------
buf <- ring::ring_buffer_bytes(100, 8)

## ------------------------------------------------------------------------
buf$push(as.raw(1:8))

## ----error = TRUE--------------------------------------------------------
buf$push(as.raw(1:4))

## ------------------------------------------------------------------------
buf$read(1)

## ------------------------------------------------------------------------
buf$used()

## ------------------------------------------------------------------------
buf$used(bytes = TRUE)

## ------------------------------------------------------------------------
buf <- ring::ring_buffer_bytes_typed(10, double(1))

## ------------------------------------------------------------------------
buf$push(pi)

## ------------------------------------------------------------------------
buf$take(1)

## ------------------------------------------------------------------------
buf <- ring::ring_buffer_bytes_typed(10, double(5))
buf$push(rnorm(5))
buf$read(1)

## ------------------------------------------------------------------------
buf$push(rnorm(5 * 10))

## ------------------------------------------------------------------------
buf$take(1)

## ----error = TRUE--------------------------------------------------------
buf$take(10)

## ------------------------------------------------------------------------
(bytes <- charToRaw("hello world"))

## ------------------------------------------------------------------------
rawToChar(bytes)

## ------------------------------------------------------------------------
b <- ring::ring_buffer_bytes_translate(100, 8, charToRaw, rawToChar)

## ------------------------------------------------------------------------
b$push("abcdefgh")
b$tail()

## ----error = TRUE--------------------------------------------------------
b$push("hello!")

## ----echo = FALSE, results = "asis"--------------------------------------
writeLines(c("```c",
             readLines(system.file("include/ring/ring.h", package = "ring")),
             "```"))

## ----echo = FALSE, results = "asis"--------------------------------------
writeLines(c("```c",
             readLines(system.file("examples/example.c", package = "ring")),
             "```"))

## ----echo = FALSE, results = "asis"--------------------------------------
writeLines(c("```cpp",
             readLines(system.file("include/ring/ring.hpp", package = "ring")),
             "```"))

