% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdensity.R
\name{plotriverdensitypoints}
\alias{plotriverdensitypoints}
\title{Plot Points Used for Kernel Density}
\usage{
plotriverdensitypoints(riverdensity)
}
\arguments{
\item{riverdensity}{A river density object created by \link{makeriverdensity}.}
}
\description{
Plots the points used to calculate a kernel density object 
  in \link{makeriverdensity}.
  
  This function is intended as a visual check that a sufficient resolution was used.
}
\examples{
data(Gulk, fakefish)

Gulk_dens <- makeriverdensity(seg=fakefish$seg, vert=fakefish$vert, rivers=Gulk)

plotriverdensitypoints(riverdensity=Gulk_dens)
}
\author{
Matt Tyers
}
\seealso{
\link{makeriverdensity}, \link{plot.riverdensity}
}

