% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_direction.R
\name{upstream}
\alias{upstream}
\title{Upstream River Distance}
\usage{
upstream(
  startseg,
  endseg,
  startvert,
  endvert,
  rivers,
  flowconnected = FALSE,
  net = FALSE,
  stopiferror = TRUE,
  algorithm = NULL
)
}
\arguments{
\item{startseg}{Segment number of the start of the route}

\item{endseg}{Segment number of the end of the route}

\item{startvert}{Vertex number of the start of the route}

\item{endvert}{Vertex number of the end of the route}

\item{rivers}{The river network object to use}

\item{flowconnected}{If \code{TRUE}, only returns distance if the two input segments are flow-connected.  Defaults to \code{FALSE}.}

\item{net}{Whether to calculate net distance (\code{net=TRUE}) or total
distance (\code{net=FALSE})}

\item{stopiferror}{Whether or not to exit with an error if a route cannot be
found.  If this is set to \code{FALSE} and a route cannot be found,
the function will return \code{NA} in the appropriate entry.  Defaults to \code{TRUE}.  See \link{detectroute}.}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"},
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the
default), the function will automatically make a selection.  See
\link{detectroute} for more details.}
}
\value{
Upstream distance (numeric).  Returns NA if \code{flowconnected} has value \code{TRUE} and the two segments are not flow-connected.
}
\description{
Calculates river network distances as +/-, defined as
  upriver/downriver.
 
  Specifying \code{net=TRUE} will compute net upriver distance (3 river km
  down a tributary and then 15 river km up the mainstem will mean 12 rkm net.
  Otherwise the function will return 18 rkm upriver travel.)
 
  The mouth (lowest point) segment and vertex must be specified (see
  \link{setmouth}).
}
\note{
Building routes from the river mouth to each river network segment and/or distance lookup tables will
  greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk)

# Mouth must be specified
Gulk$mouth$mouth.seg <- 1
Gulk$mouth$mouth.vert <- 1

plot(x=Gulk)
riverpoints(seg=c(6,4), vert=c(140,140), pch=16, col=2, rivers=Gulk)
upstream(startseg=6, endseg=4, startvert=140, endvert=40, rivers=Gulk, net=TRUE)
upstream(startseg=6, endseg=4, startvert=140, endvert=40, rivers=Gulk, net=FALSE)
upstream(startseg=6, endseg=4, startvert=140, endvert=40, rivers=Gulk, flowconnected=TRUE)
}
\seealso{
\link{setmouth}
}
\author{
Matt Tyers
}
