% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riverdist_1.R
\name{xy2segvert}
\alias{xy2segvert}
\title{Convert XY Coordinates to River Locations}
\usage{
xy2segvert(x, y, rivers)
}
\arguments{
\item{x}{A vector of x-coordinates to transform}

\item{y}{A vector of y-coordinates to transform}

\item{rivers}{The river network object to use}
}
\value{
A data frame of river locations, with segment numbers in \code{$seg}, vertex numbers in \code{$vert}, and the snapping distance for each point in \code{$snapdist}.
}
\description{
This function determines the closest vertex in the river network
  to each point of XY data and returns a list of river locations, defined 
  as segment numbers and vertex numbers.
}
\note{
Conversion to river locations is only valid if the input XY 
  coordinates and river network are in the same projected coordinate system. 
  Point data in geographic coordinates can be projected using 
  \link[rgdal]{project} in package 'rgdal', and an example is shown below.
}
\examples{
data(Gulk,fakefish)
head(fakefish)

fakefish.riv <- xy2segvert(x=fakefish$x, y=fakefish$y, rivers=Gulk)
head(fakefish.riv)

plot(x=Gulk, xlim=c(862000,882000), ylim=c(6978000,6993000))
points(fakefish$x, fakefish$y, pch=16, col=2)
riverpoints(seg=fakefish.riv$seg, vert=fakefish.riv$vert, rivers=Gulk, pch=15, col=4)


## converting a matrix of points stored in long-lat to Alaska Albers Equal Area:
data(line98, Kenai1)
head(line98)  # note that coordinates are stored in long-lat, NOT lat-long

library(rgdal)
line98albers <- project(line98,proj="+proj=aea +lat_1=55 +lat_2=65 
    +lat_0=50 +lon_0=-154 +x_0=0 +y_0=0 +datum=NAD83 +units=m +no_defs 
    +ellps=GRS80")
head(line98albers)

zoomtoseg(seg=c(162,19), rivers=Kenai1)
points(line98albers)
}
\author{
Matt Tyers
}
