% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_riverdistance.R
\name{homerangeoverlap}
\alias{homerangeoverlap}
\title{Home Range Overlap}
\usage{
homerangeoverlap(x)
}
\arguments{
\item{x}{An object returned from \link{homerange}.}
}
\value{
A list of three matrices, with \code{$either} giving the distances represented by the union of home ranges of each pair of individuals, and \code{$both} giving the distances represented by the intersection of home ranges of each pair of individuals.  Element \code{$prop_both} gives the proportion of overlap, defined as intersection/union.
}
\description{
Returns matrices describing the overlap of the minimum observed home range for multiple
  observations of each individual fish.
}
\examples{
data(Gulk, fakefish)
ranges <- with(fakefish, homerange(unique=fish.id, survey=flight, seg=seg, vert=vert, rivers=Gulk))
ranges

# 19 plots will be produced, recommend calling par(mfrow=c(4,5))
plot(ranges)
plot(ranges,cumulative=TRUE,label=TRUE)

homerangeoverlap(ranges)

plothomerangeoverlap(ranges)
with(fakefish, riverpoints(seg=seg, vert=vert, rivers=Gulk))
}
\seealso{
\link{homerange}, \link{plot.homerange}, \link{plothomerangeoverlap}
}
\author{
Matt Tyers
}
