/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqOptimized;
import scala.collection.IndexedSeqOptimized$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.mutable.Builder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt;
import scala.runtime.ScalaRunTime$;

public abstract class IndexedSeqOptimized$class {
    public static boolean isEmpty(IndexedSeqOptimized $this) {
        return $this.length() == 0;
    }

    public static void foreach(IndexedSeqOptimized $this, Function1 f) {
        int len = $this.length();
        for (int i = 0; i < len; ++i) {
            f.apply($this.apply(i));
        }
    }

    public static boolean forall(IndexedSeqOptimized $this, Function1 p$2) {
        return $this.prefixLength(new IndexedSeqOptimized$.anonfun.forall.1($this, p$2)) == $this.length();
    }

    public static boolean exists(IndexedSeqOptimized $this, Function1 p$1) {
        return $this.prefixLength(new IndexedSeqOptimized$.anonfun.exists.1($this, p$1)) != $this.length();
    }

    public static Option find(IndexedSeqOptimized $this, Function1 p$3) {
        int i = $this.prefixLength(new IndexedSeqOptimized$.anonfun.1($this, p$3));
        return i < $this.length() ? new Some($this.apply(i)) : None$.MODULE$;
    }

    private static Object foldl(IndexedSeqOptimized $this, int start, int end, Object z, Function2 op) {
        while (start != end) {
            z = op.apply(z, $this.apply(start));
            ++start;
        }
        return z;
    }

    private static Object foldr(IndexedSeqOptimized $this, int start, int end, Object z, Function2 op) {
        while (start != end) {
            z = op.apply($this.apply(end - 1), z);
            --end;
        }
        return z;
    }

    public static Object foldLeft(IndexedSeqOptimized $this, Object z, Function2 op) {
        return IndexedSeqOptimized$class.foldl($this, 0, $this.length(), z, op);
    }

    public static Object foldRight(IndexedSeqOptimized $this, Object z, Function2 op) {
        return IndexedSeqOptimized$class.foldr($this, 0, $this.length(), z, op);
    }

    public static Object reduceLeft(IndexedSeqOptimized $this, Function2 op) {
        return $this.length() > 0 ? IndexedSeqOptimized$class.foldl($this, 1, $this.length(), $this.apply(0), op) : $this.scala$collection$IndexedSeqOptimized$$super$reduceLeft(op);
    }

    public static Object reduceRight(IndexedSeqOptimized $this, Function2 op) {
        return $this.length() > 0 ? IndexedSeqOptimized$class.foldr($this, 0, $this.length() - 1, $this.apply($this.length() - 1), op) : $this.scala$collection$IndexedSeqOptimized$$super$reduceRight(op);
    }

    public static Object zip(IndexedSeqOptimized $this, Iterable that, CanBuildFrom bf) {
        Object object;
        if (that instanceof IndexedSeq) {
            IndexedSeq indexedSeq = (IndexedSeq)that;
            Builder b = bf.apply($this.repr());
            int n = $this.length();
            int len = new RichInt(n).min(indexedSeq.length());
            b.sizeHint(len);
            for (int i = 0; i < len; ++i) {
                b.$plus$eq(new Tuple2($this.apply(i), indexedSeq.apply(i)));
            }
            object = b.result();
        } else {
            object = $this.scala$collection$IndexedSeqOptimized$$super$zip(that, bf);
        }
        return object;
    }

    public static Object zipWithIndex(IndexedSeqOptimized $this, CanBuildFrom bf) {
        Builder b = bf.apply($this.repr());
        int len = $this.length();
        b.sizeHint(len);
        for (int i = 0; i < len; ++i) {
            b.$plus$eq(new Tuple2($this.apply(i), BoxesRunTime.boxToInteger(i)));
        }
        return b.result();
    }

    public static Object slice(IndexedSeqOptimized $this, int from2, int until2) {
        int i;
        int end = new RichInt(until2).min($this.length());
        Builder b = $this.newBuilder();
        b.sizeHint(end - i);
        for (i = new RichInt(from2).max(0); i < end; ++i) {
            b.$plus$eq($this.apply(i));
        }
        return b.result();
    }

    public static Object head(IndexedSeqOptimized $this) {
        return $this.isEmpty() ? $this.scala$collection$IndexedSeqOptimized$$super$head() : $this.apply(0);
    }

    public static Object tail(IndexedSeqOptimized $this) {
        return $this.isEmpty() ? $this.scala$collection$IndexedSeqOptimized$$super$tail() : $this.slice(1, $this.length());
    }

    public static Object last(IndexedSeqOptimized $this) {
        return $this.length() > 0 ? $this.apply($this.length() - 1) : $this.scala$collection$IndexedSeqOptimized$$super$last();
    }

    public static Object init(IndexedSeqOptimized $this) {
        return $this.length() > 0 ? $this.slice(0, $this.length() - 1) : $this.scala$collection$IndexedSeqOptimized$$super$init();
    }

    public static Object take(IndexedSeqOptimized $this, int n) {
        return $this.slice(0, n);
    }

    public static Object drop(IndexedSeqOptimized $this, int n) {
        return $this.slice(n, $this.length());
    }

    public static Object takeRight(IndexedSeqOptimized $this, int n) {
        return $this.slice($this.length() - n, $this.length());
    }

    public static Object dropRight(IndexedSeqOptimized $this, int n) {
        return $this.slice(0, $this.length() - n);
    }

    public static Tuple2 splitAt(IndexedSeqOptimized $this, int n) {
        return new Tuple2($this.take(n), $this.drop(n));
    }

    public static Object takeWhile(IndexedSeqOptimized $this, Function1 p) {
        return $this.take($this.prefixLength(p));
    }

    public static Object dropWhile(IndexedSeqOptimized $this, Function1 p) {
        return $this.drop($this.prefixLength(p));
    }

    public static Tuple2 span(IndexedSeqOptimized $this, Function1 p) {
        return $this.splitAt($this.prefixLength(p));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean sameElements(IndexedSeqOptimized $this, Iterable that) {
        if (that instanceof IndexedSeq) {
            int i;
            IndexedSeq indexedSeq = (IndexedSeq)that;
            int len = $this.length();
            if (len != indexedSeq.length()) return false;
            for (i = 0; i < len; ++i) {
                void y0;
                void x0;
                Object a = indexedSeq.apply(i);
                Object a2 = $this.apply(i);
                if (!(a2 == a ? true : (x0 == null ? false : (x0 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x0, y0) : (x0 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x0, y0) : x0.equals(y0)))))) break;
            }
            if (i != len) return false;
            return true;
        }
        boolean bl = $this.scala$collection$IndexedSeqOptimized$$super$sameElements(that);
        return bl;
    }

    public static void copyToArray(IndexedSeqOptimized $this, Object xs, int start, int len) {
        int i = 0;
        int j = start;
        int n = $this.length();
        int n2 = new RichInt(n).min(len);
        int end = new RichInt(n2).min(ScalaRunTime$.MODULE$.array_length(xs) - start);
        while (i < end) {
            ScalaRunTime$.MODULE$.array_update(xs, j, $this.apply(i));
            ++i;
            ++j;
        }
    }

    public static int lengthCompare(IndexedSeqOptimized $this, int len) {
        return $this.length() - len;
    }

    public static int segmentLength(IndexedSeqOptimized $this, Function1 p, int from2) {
        int i;
        int len = $this.length();
        for (i = from2; i < len && BoxesRunTime.unboxToBoolean(p.apply($this.apply(i))); ++i) {
        }
        return i - from2;
    }

    private static int negLength(IndexedSeqOptimized $this, int n) {
        return n == $this.length() ? -1 : n;
    }

    public static int indexWhere(IndexedSeqOptimized $this, Function1 p$4, int from2) {
        int start = new RichInt(from2).max(0);
        return IndexedSeqOptimized$class.negLength($this, start + $this.segmentLength(new IndexedSeqOptimized$.anonfun.indexWhere.1($this, p$4), start));
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexWhere(IndexedSeqOptimized $this, Function1 p, int end) {
        void var3_3;
        for (int i = end; i >= 0 && !BoxesRunTime.unboxToBoolean(p.apply($this.apply(i))); --i) {
        }
        return (int)var3_3;
    }

    public static Object reverse(IndexedSeqOptimized $this) {
        Builder b = $this.newBuilder();
        b.sizeHint($this.length());
        int i = $this.length();
        while (0 < i) {
            b.$plus$eq($this.apply(--i));
        }
        return b.result();
    }

    public static Iterator reverseIterator(IndexedSeqOptimized $this) {
        return new IndexedSeqOptimized$.anon.1($this);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startsWith(IndexedSeqOptimized $this, Seq that, int offset) {
        boolean bl;
        if (that instanceof IndexedSeq) {
            int j;
            IndexedSeq indexedSeq = (IndexedSeq)that;
            int i = offset;
            int thisLen = $this.length();
            int thatLen = indexedSeq.length();
            for (j = 0; i < thisLen && j < thatLen; ++i, ++j) {
                void y0;
                void x0;
                Object a = indexedSeq.apply(j);
                Object a2 = $this.apply(i);
                if (!(a2 == a ? true : (x0 == null ? false : (x0 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x0, y0) : (x0 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x0, y0) : x0.equals(y0)))))) break;
            }
            bl = j == thatLen;
        } else {
            int thisLen = $this.length();
            Iterator thatElems = that.iterator();
            for (int i = offset; i < thisLen && thatElems.hasNext(); ++i) {
                void y1;
                void x1;
                Object a = thatElems.next();
                Object a3 = $this.apply(i);
                if (a3 == a ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))))) {
                    continue;
                }
                return false;
            }
            bl = !thatElems.hasNext();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean endsWith(IndexedSeqOptimized $this, Seq that) {
        if (that instanceof IndexedSeq) {
            IndexedSeq indexedSeq = (IndexedSeq)that;
            int i = $this.length() - 1;
            int j = indexedSeq.length() - 1;
            if (j > i) return false;
            while (j >= 0) {
                boolean bl;
                Object a = indexedSeq.apply(j);
                Object a2 = $this.apply(i);
                if (a2 == a) {
                    bl = true;
                } else {
                    void y0;
                    void x0;
                    if (x0 == null) {
                        return false;
                    }
                    bl = x0 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x0, y0) : (x0 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x0, y0) : x0.equals(y0));
                }
                if (!bl) return false;
                --i;
                --j;
            }
            if (!true) return false;
            return true;
        }
        boolean bl = $this.scala$collection$IndexedSeqOptimized$$super$endsWith(that);
        return bl;
    }

    public static void $init$(IndexedSeqOptimized $this) {
    }
}

