% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expression.R
\name{Array}
\alias{Array}
\title{create an array}
\description{
Create an array in MiniZinc
}
\examples{
newArray = Array$new(exprVec = c(Int$new(1), Int$new(2)))
newArray$c_str()
}
\section{Super class}{
\code{\link[rminizinc:Expression]{rminizinc::Expression}} -> \code{Array}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.exprVec}}{vector of value expressions}

\item{\code{.dims}}{vector of dimension expressions}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.exprVec}}{vector of value expressions}

\item{\code{.dims}}{vector of dimension expressions}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Array$new()}}
\item \href{#method-ndims}{\code{Array$ndims()}}
\item \href{#method-getMinIndex}{\code{Array$getMinIndex()}}
\item \href{#method-getMaxIndex}{\code{Array$getMaxIndex()}}
\item \href{#method-setMinIndex}{\code{Array$setMinIndex()}}
\item \href{#method-setMaxIndex}{\code{Array$setMaxIndex()}}
\item \href{#method-getVal}{\code{Array$getVal()}}
\item \href{#method-setVal}{\code{Array$setVal()}}
\item \href{#method-c_str}{\code{Array$c_str()}}
\item \href{#method-getDeleteFlag}{\code{Array$getDeleteFlag()}}
\item \href{#method-delete}{\code{Array$delete()}}
\item \href{#method-clone}{\code{Array$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for an int literal
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$new(exprVec, dimranges = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{exprVec}}{list of expressions in the array}

\item{\code{dimranges}}{list of min and max index of each dimension}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ndims"></a>}}
\if{latex}{\out{\hypertarget{method-ndims}{}}}
\subsection{Method \code{ndims()}}{
get the number of dimensions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$ndims()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getMinIndex"></a>}}
\if{latex}{\out{\hypertarget{method-getMinIndex}{}}}
\subsection{Method \code{getMinIndex()}}{
get the minimum index of dimension i
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$getMinIndex(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{ith dimension}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getMaxIndex"></a>}}
\if{latex}{\out{\hypertarget{method-getMaxIndex}{}}}
\subsection{Method \code{getMaxIndex()}}{
get the maximum index of dimension i
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$getMaxIndex(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{ith dimension}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setMinIndex"></a>}}
\if{latex}{\out{\hypertarget{method-setMinIndex}{}}}
\subsection{Method \code{setMinIndex()}}{
set the minimum index of dimension i
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$setMinIndex(i, minIndex)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{dimension number}

\item{\code{minIndex}}{integer for min index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setMaxIndex"></a>}}
\if{latex}{\out{\hypertarget{method-setMaxIndex}{}}}
\subsection{Method \code{setMaxIndex()}}{
set the maximum index of dimension i
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$setMaxIndex(i, maxIndex)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{dimension number}

\item{\code{maxIndex}}{integer for max index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getVal"></a>}}
\if{latex}{\out{\hypertarget{method-getVal}{}}}
\subsection{Method \code{getVal()}}{
get the ith element from vector
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$getVal(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setVal"></a>}}
\if{latex}{\out{\hypertarget{method-setVal}{}}}
\subsection{Method \code{setVal()}}{
set the ith element from vector
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$setVal(i, val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}

\item{\code{val}}{value of expression to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
return the MiniZinc representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the assignment item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Array$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
