% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterrnaCrosslinkMethodsAndHelpers.R
\docType{methods}
\name{plotClusterAgreementHeat}
\alias{plotClusterAgreementHeat}
\alias{plotClusterAgreementHeat,rnaCrosslinkDataSet-method}
\title{Plot a heatmap that plots the agreements between replicates 
after clusterrnaCrosslink has been performed}
\usage{
plotClusterAgreementHeat(cds, analysisStage = "originalClusters")
}
\arguments{
\item{cds}{A rnaCrosslinkDataSet object}

\item{analysisStage}{The stage of the analysis to plot}
}
\value{
A heatmap of the agreement between replicates in the analysis stage chosen
}
\description{
Plot a heatmap that plots the agreements between replicates 
after clusterrnaCrosslink has been performed
}
\examples{

cds = makeExamplernaCrosslinkDataSet()


clusteredCds = clusterrnaCrosslink(cds,
                cores = 1,
                stepCount = 1,
                clusterCutoff = 0)


plotClusterAgreementHeat(cds)



}
