% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainr.R
\name{trainr}
\alias{trainr}
\title{Recurrent Neural Network}
\usage{
trainr(
  Y,
  X,
  model = NULL,
  learningrate,
  learningrate_decay = 1,
  momentum = 0,
  hidden_dim = c(10),
  network_type = "rnn",
  numepochs = 1,
  sigmoid = c("logistic", "Gompertz", "tanh"),
  use_bias = F,
  batch_size = 1,
  seq_to_seq_unsync = F,
  update_rule = "sgd",
  epoch_function = c(epoch_print, epoch_annealing),
  loss_function = loss_L1,
  ...
)
}
\arguments{
\item{Y}{array of output values, dim 1: samples (must be equal to dim 1 of X), dim 2: time (must be equal to dim 2 of X), dim 3: variables (could be 1 or more, if a matrix, will be coerce to array)}

\item{X}{array of input values, dim 1: samples, dim 2: time, dim 3: variables (could be 1 or more, if a matrix, will be coerce to array)}

\item{model}{a model trained before, used for retraining purpose.}

\item{learningrate}{learning rate to be applied for weight iteration}

\item{learningrate_decay}{coefficient to apply to the learning rate at each epoch, via the epoch_annealing function}

\item{momentum}{coefficient of the last weight iteration to keep for faster learning}

\item{hidden_dim}{dimension(s) of hidden layer(s)}

\item{network_type}{type of network, could be rnn, gru or lstm. gru and lstm are experimentale.}

\item{numepochs}{number of iteration, i.e. number of time the whole dataset is presented to the network}

\item{sigmoid}{method to be passed to the sigmoid function}

\item{use_bias}{should the network use bias}

\item{batch_size}{batch size: number of samples used at each weight iteration, only 1 supported for the moment}

\item{seq_to_seq_unsync}{if TRUE, the network will be trained to backpropagate only the second half of the output error. If many to one is the target, just make Y have a time dim of 1. The X and Y data are modify at first to fit a classic learning, error are set to 0 during back propagation, input for the second part is also set to 0.}

\item{update_rule}{rule to update the weight, "sgd", the default, is stochastic gradient descent, other available options are "adagrad" (experimentale, do not learn yet)}

\item{epoch_function}{vector of functions to applied at each epoch loop. Use it to intereact with the objects inside the list model or to print and plot at each epoch. Should return the model.}

\item{loss_function}{loss function, applied in each sample loop, vocabulary to verify.}

\item{...}{Arguments to be passed to methods, to be used in user defined functions}
}
\value{
a model to be used by the predictr function
}
\description{
Trains a Recurrent Neural Network.
}
\examples{
\dontrun{
# create training numbers
X1 = sample(0:127, 10000, replace=TRUE)
X2 = sample(0:127, 10000, replace=TRUE)

# create training response numbers
Y <- X1 + X2

# convert to binary
X1 <- int2bin(X1, length=8)
X2 <- int2bin(X2, length=8)
Y  <- int2bin(Y,  length=8)

# create 3d array: dim 1: samples; dim 2: time; dim 3: variables
X <- array( c(X1,X2), dim=c(dim(X1),2) )

# train the model
model <- trainr(Y=Y,
                X=X,
                learningrate   =  1,
                hidden_dim     = 16  )
}
    
}
