% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{covControl}
\alias{covControl}
\title{Tuning parameters for Huber M-estimation of location and scatter}
\usage{
covControl(prob = 0.95, maxIterations = 200, tol = 1e-07)
}
\arguments{
\item{prob}{numeric; probability for the quantile of the
\eqn{\chi^{2}}{chi-squared} distribution to be used as cutoff point in the
Huber weight function (defaults to 0.95).}

\item{maxIterations}{an integer giving the maximum number of iterations in
the iteratively reweighted algorithm.}

\item{tol}{a small positive numeric value to be used to determine
convergence of the iteratively reweighted algorithm.}
}
\value{
A list with components corresponding to the arguments.
}
\description{
Obtain a list with tuning paramters for \code{\link{covHuber}}.
}
\author{
Andreas Alfons
}
\references{
Huber, P.J. (1981) \emph{Robust statistics}. John Wiley & Sons.
}
\seealso{
\code{\link{covHuber}}
}
\keyword{multivariate}

