% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_mediation.R
\name{test_mediation}
\alias{test_mediation}
\alias{print.boot_test_mediation}
\alias{print.sobel_test_mediation}
\alias{test_mediation.formula}
\alias{test_mediation.default}
\alias{test_mediation.fit_mediation}
\alias{robmed}
\title{(Robust) mediation analysis}
\usage{
test_mediation(object, ...)

\method{test_mediation}{formula}(
  formula,
  data,
  test = c("boot", "sobel"),
  alternative = c("twosided", "less", "greater"),
  R = 5000,
  level = 0.95,
  type = c("bca", "perc"),
  order = c("first", "second"),
  method = c("regression", "covariance"),
  robust = TRUE,
  family = "gaussian",
  contrast = FALSE,
  fit_yx = TRUE,
  control = NULL,
  ...
)

\method{test_mediation}{default}(
  object,
  x,
  y,
  m,
  covariates = NULL,
  test = c("boot", "sobel"),
  alternative = c("twosided", "less", "greater"),
  R = 5000,
  level = 0.95,
  type = c("bca", "perc"),
  order = c("first", "second"),
  method = c("regression", "covariance"),
  robust = TRUE,
  family = "gaussian",
  model = c("parallel", "serial"),
  contrast = FALSE,
  fit_yx = TRUE,
  control = NULL,
  ...
)

\method{test_mediation}{fit_mediation}(
  object,
  test = c("boot", "sobel"),
  alternative = c("twosided", "less", "greater"),
  R = 5000,
  level = 0.95,
  type = c("bca", "perc"),
  order = c("first", "second"),
  ...
)

robmed(..., test = "boot", method = "regression", robust = TRUE)
}
\arguments{
\item{object}{the first argument will determine the method of the generic
function to be dispatched.  For the default method, this should be a data
frame containing the variables.  There is also a method for a mediation
model fit as returned by \code{\link{fit_mediation}()}.}

\item{\dots}{additional arguments to be passed down.  For the bootstrap
tests, those can be used to specify arguments of \code{\link[boot]{boot}()},
for example for parallel computing.}

\item{formula}{an object of class "formula" (or one that can be coerced to
that class): a symbolic description of the model to be fitted.  Hypothesized
mediator variables should be wrapped in a call to \code{\link{m}()} (see
examples), and any optional control variables should be wrapped in a call to
\code{\link{covariates}()}.}

\item{data}{for the \code{formula} method, a data frame containing the
variables.}

\item{test}{a character string specifying the test to be performed for
the indirect effects.  Possible values are \code{"boot"} (the default) for
the bootstrap, or \code{"sobel"} for Sobel's test.  Currently, Sobel's test
is not implemented for models with multiple indirect effects.}

\item{alternative}{a character string specifying the alternative hypothesis
in the test for the indirect effects.  Possible values are \code{"twosided"}
(the default), \code{"less"} or \code{"greater"}.}

\item{R}{an integer giving the number of bootstrap replicates.  The default
is to use 5000 bootstrap replicates.}

\item{level}{numeric; the confidence level of the confidence interval in
the bootstrap test.  The default is to compute a 95\% confidence interval.}

\item{type}{a character string specifying the type of confidence interval
to be computed in the bootstrap test.  Possible values are \code{"bca"} (the
default) for the bias-corrected and accelerated bootstrap, or \code{"perc"}
for the percentile bootstrap.}

\item{order}{a character string specifying the order of approximation of
the standard error in Sobel's test.  Possible values are \code{"first"}
(the default) for a first-order approximation, and \code{"second"} for a
second-order approximation.}

\item{method}{a character string specifying the method of estimation for
the mediation model.  Possible values are \code{"regression"} (the default)
to estimate the effects via regressions, or \code{"covariance"} to estimate
the effects via the covariance matrix.  Note that the effects are
always estimated via regressions if more than one independent variable or
hypothesized mediator is specified, or if control variables are supplied.}

\item{robust}{a logical indicating whether to perform a robust test
(defaults to \code{TRUE}).  For estimation via regressions
(\code{method = "regression"}), this can also be a character string, with
\code{"MM"} specifying the MM-estimator of regression, and \code{"median"}
specifying median regression.}

\item{family}{a character string specifying the error distribution to be
used in maximum likelihood estimation of regression models.  Possible values
are \code{"gaussian"} for a normal distribution (the default),
\code{skewnormal} for a skew-normal distribution, \code{"student"} for
Student's t distribution, \code{"skewt"} for a skew-t distribution, or
\code{"select"} to select among these four distributions via BIC (see
\code{\link{fit_mediation}()} for details).  This is only relevant if
\code{method = "regression"} and \code{robust = FALSE}.}

\item{contrast}{a logical indicating whether to compute pairwise contrasts
of the indirect effects (defaults to \code{FALSE}).  This can also be a
character string, with \code{"estimates"} for computing the pairwise
differences of the indirect effects (such that it is tested whether two
indirect effects are equal), and \code{"absolute"} for computing the
pairwise differences of the absolute values of the indirect effects
(such that it is tested whether two indirect effects are equal in
magnitude).  This is only relevant for models with multiple indirect
effects, which are currently only implemented for estimation via
regressions (\code{method = "regression"}).  For models with multiple
independent variables of interest and multiple hypothesized mediators,
contrasts are only computed between indirect effects corresponding to
the same independent variable.}

\item{fit_yx}{a logical indicating whether to fit the regression model
\code{y ~ x + covariates} to estimate the total effect (the default is
\code{TRUE}).  This is only relevant if \code{method = "regression"} and
\code{robust = FALSE}.}

\item{control}{a list of tuning parameters for the corresponding robust
method.  For robust regression (\code{method = "regression"}, and
\code{robust = TRUE} or \code{robust = "MM"}), a list of tuning
parameters for \code{\link[robustbase]{lmrob}()} as generated by
\code{\link{reg_control}()}.  For winsorized covariance matrix estimation
(\code{method = "covariance"} and \code{robust = TRUE}), a list of tuning
parameters for \code{\link{cov_Huber}()} as generated by
\code{\link{cov_control}()}.  No tuning parameters are necessary for median
regression (\code{method = "regression"} and \code{robust = "median"}).}

\item{x}{a character, integer or logical vector specifying the columns of
\code{object} containing the independent variables of interest.}

\item{y}{a character string, an integer or a logical vector specifying the
column of \code{object} containing the dependent variable.}

\item{m}{a character, integer or logical vector specifying the columns of
\code{object} containing the hypothesized mediator variables.}

\item{covariates}{optional; a character, integer or logical vector
specifying the columns of \code{object} containing additional covariates to
be used as control variables.}

\item{model}{a character string specifying the type of model in case of
multiple mediators.  Possible values are \code{"parallel"} (the default) for
the parallel multiple mediator model, or \code{"serial"} for the serial
multiple mediator model.  This is only relevant for models with multiple
hypothesized mediators, which are currently only implemented for estimation
via regressions (\code{method = "regression"}).}
}
\value{
An object inheriting from class \code{"test_mediation"} (class
\code{"boot_test_mediation"} if \code{test = "boot"} or
\code{"sobel_test_mediation"} if \code{test = "sobel"}) with the
following components:
\item{a}{a numeric vector containing the bootstrap point estimates of the
effects of the independent variables on the proposed mediator variables
(only \code{"boot_test_mediation"}).}
\item{b}{a numeric vector containing the bootstrap point estimates of the
direct effects of the proposed mediator variables on the dependent variable
(only \code{"boot_test_mediation"}).}
\item{d}{in case of a serial multiple mediator model, a numeric vector
containing the bootstrap point estimates of the effects of proposed mediator
variables on other mediator variables occurring later in the sequence (only
\code{"boot_test_mediation"} if applicable.}
\item{total}{a numeric vector containing the bootstrap point estimates of
the total effects of the independent variables on the dependent variable
(only \code{"boot_test_mediation"}).}
\item{direct}{a numeric vector containing the bootstrap point estimates of
the direct effects of the independent variables on the dependent variable
(only \code{"boot_test_mediation"}).}
\item{indirect}{a numeric vector containing the bootstrap point estimates of
the indirect effects (only \code{"boot_test_mediation"}).}
\item{ab}{for back-compatibility with versions <0.10.0, the bootstrap
point estimates of the indirect effects are also included here (only
\code{"boot_test_mediation"}).  \bold{This component is deprecated and
may be removed as soon as the next version.}}
\item{ci}{a numeric vector of length two or a matrix of two columns
containing the bootstrap confidence intervals for the indirect effects
(only \code{"boot_test_mediation"}).}
\item{reps}{an object of class \code{"\link[boot]{boot}"} containing
the bootstrap replicates (only \code{"boot_test_mediation"}).  For
regression model fits, bootstrap replicates of the coefficients in the
individual regression models are stored.}
\item{se}{numeric; the standard error of the indirect effect according
to Sobel's formula (only \code{"sobel_test_mediation"}).}
\item{statistic}{numeric; the test statistic for Sobel's test (only
\code{"sobel_test_mediation"}).}
\item{p_value}{numeric; the p-value from Sobel's test (only
\code{"sobel_test_mediation"}).}
\item{alternative}{a character string specifying the alternative
hypothesis in the test for the indirect effects.}
\item{R}{an integer giving the number of bootstrap replicates (only
\code{"boot_test_mediation"}).}
\item{level}{numeric; the confidence level of the bootstrap confidence
interval (only \code{"boot_test_mediation"}).}
\item{type}{a character string specifying the type of bootstrap
confidence interval (only \code{"boot_test_mediation"}).}
\item{fit}{an object inheriting from class
\code{"\link{fit_mediation}"} containing the estimation results of the
mediation model on the original data.}
}
\description{
Perform (robust) mediation analysis via a (fast-and-robust) bootstrap test
or Sobel's test.
}
\details{
With \code{method = "regression"}, and \code{robust = TRUE} or
\code{robust = "MM"}, the tests are based on robust regressions with the
MM-estimator from \code{\link[robustbase]{lmrob}()}.  The bootstrap test is
thereby performed via the fast-and-robust bootstrap.  This is the default
behavior.

Note that the MM-estimator of regression implemented in
\code{\link[robustbase]{lmrob}()} can be seen as weighted least squares
estimator, where the weights are dependent on how much an observation is
deviating from the rest.  The trick for the fast-and-robust bootstrap is
that on each bootstrap sample, first a weighted least squares estimator
is computed (using those robustness weights from the original sample)
followed by a linear correction of the coefficients.  The purpose of this
correction is to account for the additional uncertainty of obtaining the
robustness weights.

With \code{method = "regression"} and \code{robust = "median"}, the tests
are based on median regressions with \code{\link[quantreg]{rq}()}.  Note
that the bootstrap test is performed via the standard bootstrap, as the
fast-and-robust bootstrap is not applicable.  Unlike the robust regressions
described above, median regressions are not robust against outliers in
the explanatory variables, and the standard bootstrap can suffer from
oversampling of outliers in the bootstrap samples.

With \code{method = "covariance"} and \code{robust = TRUE}, the
tests are based on a Huber M-estimator of location and scatter.  For the
bootstrap test, the M-estimates are used to first clean the data via a
transformation.  Then the standard bootstrap is performed with the cleaned
data.  Note that this covariance-based approach is less robust than the
approach based on robust regressions described above.  Furthermore, the
bootstrap does not account for the variability from cleaning the data.

\code{robmed()} is a wrapper function for performing robust mediation
analysis via regressions and the fast-and-robust bootstrap.
}
\note{
For the fast-and-robust bootstrap, the simpler correction of
Salibian-Barrera & Van Aelst (2008) is used rather than the originally
proposed correction of Salibian-Barrera & Zamar (2002).

The formula interface is still experimental and may change in future
versions.
}
\examples{
data("BSG2014")

# set seed of the random number generator
set.seed(20211117)

## The results in Alfons et al. (2021) were obtained with an
## older version of the random number generator.  To reproduce
## those results, uncomment the two lines below.
# RNGversion("3.5.3")
# set.seed(20150601)

# perform mediation analysis
test <- test_mediation(TeamCommitment ~ m(TaskConflict) + ValueDiversity,
                       data = BSG2014)
summary(test)

}
\references{
Alfons, A., Ates, N.Y. and Groenen, P.J.F. (2021) A robust bootstrap test
for mediation analysis.  \emph{Organizational Research Methods},
doi: 10.1177/1094428121999096.

Azzalini, A. and Arellano-Valle, R. B. (2013) Maximum penalized likelihood
estimation for skew-normal and skew-t distributions.  \emph{Journal of
Statistical Planning and Inference}, \bold{143}(2), 419--433.

Preacher, K.J. and Hayes, A.F. (2004) SPSS and SAS procedures for estimating
indirect effects in simple mediation models. \emph{Behavior Research Methods,
Instruments, & Computers}, \bold{36}(4), 717--731.

Preacher, K.J. and Hayes, A.F. (2008) Asymptotic and resampling strategies
for assessing and comparing indirect effects in multiple mediator models.
\emph{Behavior Research Methods}, \bold{40}(3), 879--891.

Salibian-Barrera, M. and Van Aelst, S. (2008) Robust model selection using
fast and robust bootstrap. \emph{Computational Statistics & Data Analysis},
\bold{52}(12), 5121--5135

Salibian-Barrera, M. and Zamar, R. (2002) Bootstrapping robust estimates of
regression. \emph{The Annals of Statistics}, \bold{30}(2), 556--582.

Sobel, M.E. (1982) Asymptotic confidence intervals for indirect effects in
structural equation models. \emph{Sociological Methodology}, \bold{13},
290--312.

Yuan, Y. and MacKinnon, D.P. (2014) Robust mediation analysis based on
median regression. \emph{Psychological Methods}, \bold{19}(1),
1--20.

Zu, J. and Yuan, K.-H. (2010) Local influence and robust procedures for
mediation analysis. \emph{Multivariate Behavioral Research}, \bold{45}(1),
1--44.
}
\seealso{
\code{\link{fit_mediation}()}

\code{\link[=coef.test_mediation]{coef}()},
\code{\link[=confint.test_mediation]{confint}()} and
\code{\link[=plot-methods]{plot}()} methods, \code{\link{p_value}()}

\code{\link[boot]{boot}()}, \code{\link[robustbase]{lmrob}()},
\code{\link[stats]{lm}()}, \code{\link{cov_Huber}()}, \code{\link{cov_ML}()}
}
\author{
Andreas Alfons
}
\keyword{multivariate}
