% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robomit_functions.R
\name{o_beta_boot}
\alias{o_beta_boot}
\title{Bootstrapped beta*s}
\usage{
o_beta_boot(y, x, con, m = "none", id = "none", time = "none", delta = 1, R2max, sim,
obs, rep, type, useed = NA, data)
}
\arguments{
\item{y}{Name of the dependent variable (as string).}

\item{x}{Name of the independent treatment variable (i.e. variable of interest; as string).}

\item{con}{Name of the other control variables. Provided as string in the format: "w + z +...".}

\item{m}{Name of unrelated control variables (m; see Oster 2019; as string; default m = "none").}

\item{id}{Name of the individual id variable (e.g. firm or farm; as string). Only applicable for fixed effect panel models.}

\item{time}{Name of the time variable (e.g. year or month; as string). Only applicable for fixed effect panel models.}

\item{delta}{delta for which beta* should be estimated (default is delta = 1).}

\item{R2max}{Maximum R-square for which beta* should be estimated.}

\item{sim}{Number of simulations.}

\item{obs}{Number of draws per simulation.}

\item{rep}{Bootstrapping either with (= TRUE) or without (= FALSE) replacement.}

\item{type}{Model type (either \emph{lm} or \emph{plm}; as string).}

\item{useed}{User defined seed.}

\item{data}{Dataset.}
}
\value{
Returns tibble object, which includes bootstrapped beta*s.
}
\description{
Estimates bootstrapped beta*s, i.e. the bias-adjusted treatment effects (or correlations) (following Oster 2019).
}
\details{
Estimates bootstrapped beta*s, i.e. the bias-adjusted treatment effects (or correlations) (following Oster 2019). Bootstrapping can either be done with or without replacement. The function supports linear cross sectional (see \emph{lm} objects in R) and fixed effect panel (see \emph{plm} objects in R) models.
}
\examples{
# load data, e.g. the in-build mtcars dataset
data("mtcars")
data_oster <- mtcars

# preview of data
head(data_oster)

# load robomit
require(robomit)

# estimate bootstrapped beta*
o_beta_boot(y = "mpg",            # dependent variable
            x = "wt",             # independent treatment variable
            con = "hp + qsec",    # other control variables
            delta = 1,            # define beta. This is usually set to 1
            R2max = 0.9,          # maximum R-square
            sim = 100,            # number of simulations
            obs = 30,             # draws per simulation
            rep = FALSE,          # bootstrapping with or without replacement
            type = "lm",          # model type
            useed = 123,          # seed
            data = data_oster)    # dataset
}
\references{
Oster, E. (2019). Unobservable selection and coefficient stability: Theory and evidence. Journal of Business & Economic Statistics, 37, 187-204.
}
