% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationStudies.R
\name{viewCopyOfSimulationStudy}
\alias{viewCopyOfSimulationStudy}
\title{Access Simulation Study Code}
\usage{
viewCopyOfSimulationStudy(
  study = c("sensitivityCurves.R", "consistencyAndEfficiencyDiagonal.R",
    "consistencyAndEfficiencyBlockDiagonal.R", "breakdown.R", "convergence.R",
    "robustnessDiagonal.R", "robustnessBlockDiagonal.R"),
  destinationPath = getwd(),
  overwrite = FALSE
)
}
\arguments{
\item{study}{Name of the script file, partial matching is supported via
\code{\link[base]{match.arg}}.}

\item{destinationPath}{optional path to directory in which the copy of the
script should be created. By default the current working directory is
used.}

\item{overwrite}{logical; should existing destination files be overwritten?}
}
\description{
This is a convenience function to make it simple to access the simulation
study script files that are shipped with robustlmm.
}
\details{
The function creates a copy of the script file that can be safely edited
without changing the original file.
}
\examples{
\dontrun{
  viewCopyOfSimulationStudy("sensitivityCurves")
}
}
