% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaned_source_to_utterance_vector.R
\name{cleaned_source_to_utterance_vector}
\alias{cleaned_source_to_utterance_vector}
\title{Convert a character vector into an utterance vector}
\usage{
cleaned_source_to_utterance_vector(
  x,
  utteranceMarker = rock::opts$get("utteranceMarker"),
  fixed = FALSE,
  perl = TRUE
)
}
\arguments{
\item{x}{The character vector.}

\item{utteranceMarker}{The utterance marker (by default, a newline
character conform the ROCK standard).}

\item{fixed}{Whether the \code{utteranceMarker} is a regular expression.}

\item{perl}{If the \code{utteranceMarker} is a regular expression, whether it is
a perl regular expression.}
}
\description{
Utterance vectors are split by the utterance marker. Note that if \code{x} has
more than one element, the separate elements will remain separate.
}
\examples{
cleaned_source_to_utterance_vector("first\nsecond\nthird");
}
