% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\docType{data}
\name{opts}
\alias{opts}
\alias{set}
\alias{get}
\alias{reset}
\title{Options for the rock package}
\format{
An object of class \code{list} of length 4.
}
\usage{
opts
}
\description{
The \code{rock::opts} object contains three functions to set, get, and reset
options used by the rock package. Use \code{rock::opts$set} to set options,
\code{rock::opts$get} to get options, or \code{rock::opts$reset} to reset specific or
all options to their default values.
}
\details{
It is normally not necessary to get or set \code{rock} options. The defaults implement
the Reproducible Open Coding Kit (ROCK) standard, and deviating from these defaults
therefore means the processed sources and codes are not compatible and cannot be
processed by other software that implements the ROCK. Still, in some cases this
degree of customization might be desirable.

The following arguments can be passed:

\describe{
\item{...}{For \code{rock::opts$set}, the dots can be used to specify the options
to set, in the format \code{option = value}, for example, \code{utteranceMarker = "\\n"}. For
\code{rock::opts$reset}, a list of options to be reset can be passed.}
\item{option}{For \code{rock::opts$set}, the name of the option to set.}
\item{default}{For \code{rock::opts$get}, the default value to return if the
option has not been manually specified.}

}

The following options can be set:

\describe{
\item{codeRegexes}{A named character vector with one or more regular
expressions that specify how to extract the codes (that were used to code the
sources). These regular expressions \emph{must} each contain one capturing group
to capture the codes.}

\item{idRegexes}{A named character vector with one or more regular
expressions that specify how to extract the different types of
identifiers. These regular expressions \emph{must} each contain one capturing group
to capture the identifiers.}

\item{sectionRegexes}{A named character vector with one or more regular
expressions that specify how to extract the different types of sections.}

\item{autoGenerateIds}{The names of the \code{idRegexes} that, if missing, should receive
autogenerated identifiers (which consist of 'autogenerated_' followed by an
incrementing number).}

\item{persistentIds}{The names of the \code{idRegexes} for the identifiers which, once
attached to an utterance, should be attached to all following utterances as well (until
a new identifier with the same name is encountered, after which that identifier will be
attached to all following utterances, etc).}

\item{noCodes}{This regular expression is matched with all codes after they have been
extracted using the \code{codeRegexes} regular expression (i.e. they're matched against the
codes themselves without, for example, the square brackets in the default code regex). Any
codes matching this \code{noCodes} regular expression will be \strong{ignored}, i.e., removed from the
list of codes.}

\item{inductiveCodingHierarchyMarker}{For inductive coding, this marker is used to indicate
hierarchical relationships between codes. The code at the left hand side of this marker will
be considered the parent code of the code on the right hand side. More than two levels
can be specified in one code (for example, if the \code{inductiveCodingHierarchyMarker} is '>',
the code \verb{grandparent>child>grandchild} would indicate codes at three levels.}

\item{attributeContainers}{The name of YAML fragments containing case attributes (e.g.
metadata, demographic variables, quantitative data about cases, etc).}

\item{codesContainers}{The name of YAML fragments containing (parts of) deductive coding
trees.}

\item{delimiterRegEx}{The regular expression that is used to extract the YAML fragments.}

\item{codeDelimiters}{A character vector of two elements
specifying the opening and closing delimiters of codes (conform
the default ROCK convention, two square brackets). The square
brackets will be escaped; other characters will not, but will
be used as-is.}

\item{ignoreRegex}{The regular expression that is used to delete lines before any other
processing. This can be used to enable adding comments to sources, which are then ignored
during analysis.}

\item{includeBootstrap}{Whether to include the default bootstrap CSS.}

\item{utteranceMarker}{How to specify breaks between utterances in the source(s). The
ROCK convention is to use a newline (\verb{\\\\n}).}

\item{coderId}{A regular expression specifying the coder identifier, specified
similarly to the codeRegexes.}

\item{idForOmittedCoderIds}{The identifier to use for utterances that do not
have a coder id (i.e. utterance that occur in a source that does not specify
a coder id, or above the line where a coder id is specified).}

}
}
\examples{
### Get the default utteranceMarker
rock::opts$get(utteranceMarker);

### Set it to a custom version, so that every line starts with a pipe
rock::opts$set(utteranceMarker = "\n|");

### Check that it worked
rock::opts$get(utteranceMarker);

### Reset this option to its default value
rock::opts$reset(utteranceMarker);

### Check that the reset worked, too
rock::opts$get(utteranceMarker);

}
\keyword{datasets}
