% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3.R
\name{setupMariaDB}
\alias{setupMariaDB}
\title{Setup database driver and define connection parameters for MariaDB using \link[RMariaDB:RMariaDB-package]{RMariaDB} package.
Wrapper for setupDriver() function.}
\usage{
setupMariaDB(
  db,
  host = "127.0.0.1",
  port = "3306",
  dbname = "mydb",
  user = "root",
  password = "password",
  ...,
  protect = c("password", "user")
)
}
\arguments{
\item{db}{rocker object}

\item{host}{Host name or IP number}

\item{port}{Port number}

\item{dbname}{Database name}

\item{user}{User name}

\item{password}{Password}

\item{...}{Optional, additional suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{protect}{Parameters to be hidden}
}
\value{
Invisible self
}
\description{
Setup database driver and define connection parameters for MariaDB using \link[RMariaDB:RMariaDB-package]{RMariaDB} package.
Wrapper for setupDriver() function.
}
\examples{
db <- rocker::newDB()
rocker::setupMariaDB(
  db,
  host = "127.0.0.1", port = "3306", dbname = "mydb",
  user = "root", password = "password"
)
rocker::unloadDriver(db)
}
