% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embedding.r
\name{embed_text}
\alias{embed_text}
\title{Generate Embeddings}
\usage{
embed_text(
  text,
  model = NULL,
  server = NULL,
  model_params = NULL,
  verbose = getOption("rollama_verbose", default = interactive())
)
}
\arguments{
\item{text}{text vector to generate embeddings for.}

\item{model}{which model to use. See \url{https://ollama.ai/library} for options.
Default is "llama2". Set option(rollama_model = "modelname") to change
default for the current session. See \link{pull_model} for more details.}

\item{server}{URL to an Ollama server (not the API). Defaults to
"http://localhost:11434".}

\item{model_params}{a named list of additional model parameters listed in the
documentation for the Modelfile such as temperature.}

\item{verbose}{Whether to print status messages to the Console
(\code{TRUE}/\code{FALSE}). The default is to have status messages in
interactive sessions. Can be changed with \code{options(rollama_verbose =
  FALSE)}.}
}
\value{
a tibble with embeddings.
}
\description{
Generate Embeddings
}
\examples{
\dontrun{
embed_text(c("Here is an article about llamas...",
             "R is a language and environment for statistical computing and graphics."))
}
}
