% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_grid_squaretile.R
\name{build_grid_squaretile}
\alias{build_grid_squaretile}
\title{Create a grid with square tiles}
\usage{
build_grid_squaretile(coords, npts, pad = 0, ...)
}
\arguments{
\item{coords}{A matrix or \code{data.frame} of coordinates with two columns}

\item{npts}{The approximate total number of points of the output grid}

\item{pad}{Padding on each dimension (a positive number makes a grid
that is larger than the ranges of the coordinates).}

\item{...}{other arguments are silently ignored}
}
\value{
The coordinates of a grid of points as a \code{data.frame} with
        approximately \code{npts} rows and \code{ncol(coords)} columns. Names
        are transfered from the \code{coords} data frame.
}
\description{
Create a rectangular grid of regularly-spaced points (square
            tiles).
}
\details{


This function creates a grid that covers a set of points. The
         distance between points is the same on all dimensions (tiles are
         squared. It is only implemented for 2D grid so \code{coords} must
         have at most two columns.
}
\seealso{
Other grid.building.functions: \code{\link{build_grid_ahull_crop}};
  \code{\link{build_grid_ahull_fill}};
  \code{\link{build_grid_identical}}
}

