% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{assign_ops}
\alias{assign_ops}
\alias{\%+=\%}
\alias{\%-=\%}
\alias{\%*=\%}
\alias{\%/=\%}
\alias{\%^=\%}
\alias{\%log=\%}
\alias{\%root=\%}
\title{Assignment operators}
\usage{
x \%+=\% y

x \%-=\% y

x \%*=\% y

x \%/=\% y

x \%^=\% y

x \%log=\% y

x \%root=\% y
}
\arguments{
\item{x}{a stored value}

\item{y}{value to modify stored value by}
}
\description{
Modifies the stored value of the left-hand-side object by the right-hand-side object.
Equivalent of operators such as \code{+=} \code{-=} \code{*=} \code{/=} in languages like c++ or python.
\code{\%+=\%} and \code{\%-=\%} can also work with strings.
}
\examples{
x <- 1

x \%+=\% 2

x == 3 # TRUE

x \%-=\% 3

x == 0 # TRUE

# Or with data frames...
test <- iris

# Simply modify in-place
test$Sepal.Length[test$Species == 'setosa' & test$Petal.Length < 1.5] \%+=\% 1

# Which is much nicer than typing:
test$Sepal.Length[test$Species == 'setosa' & test$Petal.Length < 1.5] <-
test$Sepal.Length[test$Species == 'setosa' & test$Petal.Length < 1.5] + 1
# ...which is over the 100 character limit for R doccumentation!

# \%+=\% and \%-=\% also work with strings

   x <- "ab"

   x \%+=\% "c"

   x \%-=\% "b"

   x == "ac" # TRUE

# \%-=\% can also take regular expressions

   x <- "foobar"

   x \%-=\% "[f|b]"

   print(x)
   # "ooar"
}
\author{
Ben Wiseman, \email{benjamin.wiseman@kornferry.com}
}
