\name{cl2news}
\alias{cl2news}
\title{Convert ChangeLog/NEWS into NEWS.Rd}
\usage{
  cl2news(log, news = NULL, codify = TRUE,
    overwrite = TRUE)
}
\arguments{
  \item{log}{Character string, path to the ChangeLog or
  NEWS file to be converted.}

  \item{news}{Character string, path to the NEWS.Rd file to
  be written.  If \code{NULL}, results are written to
  \code{stdout()}.}

  \item{codify}{Logical, whether to try to detect code
  snippets like function names and markup them
  accordingly.}

  \item{overwrite}{Logical, whether to overwrite an
  existing NEWS.Rd file.}
}
\value{
  No return value, writes a file.
}
\description{
  This function attempts to translate ASCII ChangeLog (or
  NEWS) files into NEWS.Rd files.
}
\details{
  This should work for ChangeLog and NEWS files that
  \enumerate{ \item have entries named "Changes in version
  <version number>" (and optionally a YYYY-MM-DD date
  string afterwards) \item have single changes properly
  itemized, by indentation and then either \code{"o"},
  \code{"-"} or \code{"*"} followed by space \item
  optionally have categories as subsections, like "Fixed"
  or "Added" } Any text string that isn't indented and
  doesn't start with "Changes in version" will likely be
  treated as a subsection. The ChangeLog related functions
  and methods of this package, e.g.
  \code{\link[roxyPackage:initChangeLog]{initChangeLog}},
  are a convenient way to maintain R ChangeLogs in a proper
  format.

  This function is basically a wrapper for the internal
  function \code{tools:::news2Rd}.
}
\examples{
\dontrun{
cl2news(log="~/myFiles/myRPackage/ChangeLog", news="~/myFiles/myRPackage/inst/NEWS.Rd")

# use capture.output() to dump the results into a character vector
NEWS.object <- capture.output(cl2news(log="~/myFiles/myRPackage/ChangeLog"))
}
}
\seealso{
  \code{\link[roxyPackage:initChangeLog]{initChangeLog}},
  \code{\link[roxyPackage:readChangeLog]{readChangeLog}},
  \code{\link[roxyPackage:updateChangeLog]{updateChangeLog}},
  \code{\link[roxyPackage:writeChangeLog]{writeChangeLog}}
}

