% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_simulation_base_count_data.R
\name{getSimulationCounts}
\alias{getSimulationCounts}
\title{Get Simulation Counts}
\usage{
getSimulationCounts(
  design = NULL,
  ...,
  plannedCalendarTime,
  maxNumberOfSubjects = NA_real_,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  lambda = NA_real_,
  theta = NA_real_,
  directionUpper = NA,
  thetaH0 = 1,
  overdispersion = 0,
  fixedExposureTime = NA_real_,
  accrualTime = NA_real_,
  accrualIntensity = NA_real_,
  followUpTime = NA_real_,
  allocationRatioPlanned = NA_real_,
  maxNumberOfIterations = 1000L,
  seed = NA_real_,
  showStatistics = FALSE
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used.
In this case, Type I error rate \code{alpha}, Type II error rate \code{beta}, \code{twoSidedPower},
and \code{sided} can be directly entered as argument where necessary.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and
that a warning will be displayed if unknown arguments are passed.}

\item{plannedCalendarTime}{For simulating count data, the time points where an analysis is planned to be performed.
Should be a vector of length \code{kMax}}

\item{maxNumberOfSubjects}{\code{maxNumberOfSubjects > 0} needs to be specified for power calculations or calculation
of necessary follow-up (count data). For two treatment arms, it is the maximum number of subjects for both treatment arms.}

\item{lambda1}{A numeric value or vector that represents the assumed rate of a homogeneous Poisson process in
the active treatment group, there is no default.}

\item{lambda2}{A numeric value that represents the assumed rate of a homogeneous Poisson process in
the control group, there is no default.}

\item{lambda}{A numeric value or vector that represents the assumed rate of a homogeneous Poisson process in
the pooled treatment groups, there is no default.}

\item{theta}{A numeric value or vector that represents the assumed mean ratios lambda1/lambda2 of a homogeneous
Poisson process, there is no default.}

\item{directionUpper}{Logical. Specifies the direction of the alternative,
only applicable for one-sided testing; default is \code{TRUE}
which means that larger values of the test statistics yield smaller p-values.}

\item{thetaH0}{The null hypothesis value,
default is \code{0} for the normal and the binary case (testing means and rates, respectively),
it is \code{1} for the survival case (testing the hazard ratio).\cr\cr
For non-inferiority designs, \code{thetaH0} is the non-inferiority bound.
That is, in case of (one-sided) testing of
\itemize{
\item \emph{means}: a value \code{!= 0}
(or a value \code{!= 1} for testing the mean ratio) can be specified.
\item \emph{rates}: a value \code{!= 0}
(or a value \code{!= 1} for testing the risk ratio \code{pi1 / pi2}) can be specified.
\item \emph{survival data}: a bound for testing H0: \code{hazard ratio = thetaH0 != 1} can be specified.
\item \emph{count data}: a bound for testing H0: \code{lambda1 / lambda2 = thetaH0 != 1} can be specified.
}
For testing a rate in one sample, a value \code{thetaH0} in (0, 1) has to be specified for
defining the null hypothesis H0: \code{pi = thetaH0}.}

\item{overdispersion}{A numeric value that represents the assumed overdispersion of the negative binomial distribution,
default is \code{0}.}

\item{fixedExposureTime}{If specified, the fixed time of exposure per subject for count data, there is no default.}

\item{accrualTime}{If specified, the assumed accrual time interval(s) for the study, there is no default.}

\item{accrualIntensity}{If specified, the assumed accrual intensities for the study, there is no default.}

\item{followUpTime}{If specified, the assumed (additional) follow-up time for the study, there is no default.
The total study duration is \code{accrualTime + followUpTime}.}

\item{allocationRatioPlanned}{The planned allocation ratio \code{n1 / n2} for a two treatment groups
design, default is \code{1}. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control.
For simulating means and rates for a two treatment groups design, it can be a vector of length \code{kMax}, the number of stages.
It can be a vector of length kMax, too, for multi-arm and enrichment designs.
In these cases, a change of allocating subjects to treatment groups over the stages can be assessed.
Note that internally \code{allocationRatioPlanned} is treated as a vector of length \code{kMax}, not a scalar.}

\item{maxNumberOfIterations}{The number of simulation iterations, default is \code{1000}. Must be a positive integer of length 1.}

\item{seed}{The seed to reproduce the simulation, default is a random seed.}

\item{showStatistics}{Logical. If \code{TRUE}, summary statistics of the simulated data
are displayed for the \code{print} command, otherwise the output is suppressed, default
is \code{FALSE}.}
}
\value{
Returns a \code{\link{SimulationResults}} object.
The following generics (R generic functions) are available for this object:
\itemize{
\item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
\item \code{\link[=print.FieldSet]{print()}} to print the object,
\item \code{\link[=summary.ParameterSet]{summary()}} to display a summary of the object,
\item \code{\link[=plot.SimulationResults]{plot()}} to plot the object,
\item \code{\link[=as.data.frame.ParameterSet]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
\item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the simulated power, stopping probabilities, conditional power, and expected sample size for
testing mean rates for negative binomial distributed event numbers in the two treatment groups testing situation.
}
\details{
At given design the function simulates the power, stopping probabilities, conditional power, and expected
sample size at given number of subjects and parameter configuration.
Additionally, an allocation \code{ratio = n1/n2} and a null hypothesis value \code{thetaH0} can be specified.
}
\section{Simulation Data}{

The summary statistics "Simulated data" contains the following parameters: median \link{range}; mean +/-sd\cr

\code{$show(showStatistics = FALSE)} or \code{$setShowStatistics(FALSE)} can be used to disable
the output of the aggregated simulated data.\cr

\code{\link[=getData]{getData()}} can be used to get the aggregated simulated data from the
object as \code{\link[base]{data.frame}}. The data frame contains the following columns:
\enumerate{
\item \code{iterationNumber}: The number of the simulation iteration.
\item \code{stageNumber}: The stage.
\item \code{lambda1}: The assumed or derived event rate in the treatment group.
\item \code{lambda2}: The assumed or derived event rate in the control group.
\item \code{accrualTime}: The assumed accrualTime.
\item \code{followUpTime}: The  assumed followUpTime.
\item \code{overdispersion}: The  assumed overdispersion.
\item \code{fixedFollowUp}: The  assumed fixedFollowUp.
\item \code{numberOfSubjects}: The number of subjects under consideration when the (interim) analysis takes place.
\item \code{rejectPerStage}: 1 if null hypothesis can be rejected, 0 otherwise.
\item \code{futilityPerStage}: 1 if study should be stopped for futility, 0 otherwise.
\item \code{testStatistic}: The test statistic that is used for the test decision
\item \code{estimatedLambda1}: The estimated rate in treatment group 1.
\item \code{estimatedLambda2}: The estimated rate in treatment group 2.
\item \code{estimatedOverdispersion}: The estimated overdispersion.
\item \code{infoAnalysis}: The Fisher information at interim stage.
\item \code{trialStop}: \code{TRUE} if study should be stopped for efficacy or futility or final stage, \code{FALSE} otherwise.
\item \code{conditionalPowerAchieved}: Not yet available
}
}

\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of
the \code{rpact} specific implementation of the generic.
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and
to identify the object specific name of it, e.g.,
use \code{methods("plot")} to get all the methods for the \code{plot} generic.
There you can find, e.g., \code{plot.AnalysisResults} and
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
\dontrun{
# Fixed sample size design with two groups, fixed exposure time
getSimulationCounts(
    theta = 1.8,
    lambda2 = 0.2,
    maxNumberOfSubjects = 200,
    plannedCalendarTime = 8,
    maxNumberOfIterations = 1000,
    fixedExposureTime = 6,
    accrualTime = 3,
    overdispersion = 2)

# Group sequential design alpha spending function design with O'Brien and 
# Fleming type boundaries: Power and test characteristics for N = 264, 
# under variable exposure time with uniform recruitment over 1.25 months,
# study time (accrual + followup) = 4, interim analysis take place after
# equidistant time points (lambda1, lambda2, and overdispersion as specified,
# no futility stopping):
dOF <- getDesignGroupSequential(
    kMax = 3,
    alpha = 0.025,
    beta = 0.2,
    typeOfDesign = "asOF")

getSimulationCounts(design = dOF,
    lambda1 = seq(0.04, 0.12, 0.02),
    lambda2 = 0.12,
    directionUpper = FALSE,
    overdispersion = 5,
    plannedCalendarTime = (1:3)/3*4,
    maxNumberOfSubjects = 264,
    followUpTime = 2.75,
    accrualTime = 1.25,
    maxNumberOfIterations = 1000)
}

}
