% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{rpf.sample}
\alias{rpf.sample}
\title{Randomly sample response patterns given a list of items}
\usage{
rpf.sample(theta, items, params, ..., prefix = "i", mean = NULL,
  cov = NULL, mcar = 0, grp = NULL)
}
\arguments{
\item{theta}{either a vector (for 1 dimension) or a matrix (for >1
dimension) of person abilities or the number of response patterns
to generate randomly}

\item{items}{a list of item models}

\item{params}{a list or matrix of item parameters. If omitted, random item
parameters are generated for each item model.}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{prefix}{Column names are taken from param or items.
If no column names are available, some will be generated using
the given prefix.}

\item{mean}{mean vector of latent distribution (optional)}

\item{cov}{covariance matrix of latent distribution (optional)}

\item{mcar}{proportion of generated data to set to NA (missing completely at random)}

\item{grp}{a list with spec, param, mean, and cov}
}
\value{
Returns a data frame of response patterns
}
\description{
Returns a random sample of response patterns given a list of item
models and parameters. If \code{grp} is given then theta, items, params,
mean, and cov can be omitted.
}
\examples{
# 1 dimensional items
i1 <- rpf.drm()
i1.p <- rpf.rparam(i1)
i2 <- rpf.nrm(outcomes=3)
i2.p <- rpf.rparam(i2)
rpf.sample(5, list(i1,i2), list(i1.p, i2.p))
}
\seealso{
\code{\link{sample}}
}
