% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feat.R
\name{write.wig}
\alias{write.wig}
\title{Writing a wig file}
\usage{
write.wig(chrom, start, score, span = 1, file = NULL, append = FALSE)
}
\arguments{
\item{chrom}{A character vector giving chromosome name for each point.
Will be recycled to length(start)}

\item{start}{An integer vector giving start coordinate for each point.}

\item{score}{A numeric vector giving score at each point
Will be recycled to length(start)}

\item{span}{An integer giving span (ie, length) of each element (all
elements must have the same length, so only a single value is allowed).}

\item{file}{The name of the file to write to (will be overwritten).
A value of NULL implies write to console.}

\item{append}{Whether to append to the file.  If FALSE, file will be
overwritten.}
}
\description{
Write a fixedStep wig file
}
\examples{
write.wig(chrom=c("chr1", "chr1", "chr1", "chr1", "chr2"),
          start=c(1, 11, 21, 100, 1),
          span=3,
          score=runif(5))
}
\author{
Melissa J. Hubisz
}
\keyword{fixedStep}
\keyword{wig}

