% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rplos-package.R
\docType{package}
\name{rplos}
\alias{rplos}
\alias{rplos-package}
\alias{rplos-package}
\title{Connect with PLoS API data}
\description{
\code{rplos} provides an R interface to the PLoS Search API. More
information about each function can be found in its help documentation.
}
\section{rplos functions}{


\pkg{rplos} functions make HTTP requests using the \pkg{crul} package,
and parse json using the \pkg{jsonlite} package.
}

\section{PLoS API key}{


You used to need an API key to use this package - no longer needed
}

\section{Tutorials}{


See the rOpenSci website for a tutorial:
https://ropensci.org/tutorials/rplos_tutorial.html
}

\section{Throttling}{

Beware, PLOS recently has started throttling requests. That is,
they will give error messages like "(503) Service Unavailable -
The server cannot process the request due to a high load", which
probably means you've done too many requests in a certain time period.

Here's what they say (http://api.plos.org/solr/faq/#solr_api_recommended_usage)
on the matter:

"Please limit your API requests to 7200 requests a day, 300 per hour, 10 per
minute and allow 5 seconds for your search to return results. If you exceed this
threshold, we will lock out your IP address. If you're a high-volume user of
the PLOS Search API and need more API requests a day, please contact us at
api@plos.org to discuss your options. We currently limit API users to no more
than five concurrent connections from a single IP address.""
}

\examples{
\dontrun{
searchplos(q='ecology', fl=c('id','publication_date'), limit = 2)

# Get only full article DOIs
out <- searchplos(q="*:*", fl='id', fq='doc_type:full', start=0, limit=250)
head(out$data)

# Get DOIs for only PLoS One articles
out <- searchplos(q="*:*", fl='id', fq='journal_key:PLoSONE',
  start=0, limit=15)
head(out$data)
}

}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}

Carl Boettiger \email{cboettig@gmail.com}

Karthik Ram \email{karthik.ram@gmail.com}
}
\keyword{package}
