% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_0_1_0.R, R/rpms.R
\docType{package}
\name{rpms}
\alias{rpms}
\alias{rpms-package}
\title{rpms}
\usage{
rpms(rp_equ, data, weights = ~1, strata = ~1, clusters = ~1, e_equ = ~1,
  e_fn = "survLm", l_fn = NULL, bin_size = NULL, perm_reps = 500L,
  pval = 0.05)
}
\arguments{
\item{rp_equ}{formula containing all variables for partitioning}

\item{data}{data.frame that includes variables used in rp_equ, e_equ, 
and design information}

\item{weights}{formula or vector of sample weights for each observation}

\item{strata}{formula or vector of strata labels}

\item{clusters}{formula or vector of cluster labels}

\item{e_equ}{formula for modeling data in each node}

\item{e_fn}{string name of function to use for modeling 
(only "survLm" is operational)}

\item{l_fn}{loss function (does nothing yet)}

\item{bin_size}{numeric minimum number of observations in each node}

\item{perm_reps}{integer specifying the number of permuations}

\item{pval}{numeric p-value used to reject null hypothesis in permutation 
test}
}
\value{
object of class "rpms"
}
\description{
main function producing a regression tree using variables
 from rp_equ to partition the data and fit the model e_equ on each node.
 Currently only uses data with complete cases.

This package provides a function \code{rpms} to produce an \code{rpms} object 
and method functions that operate on them. 
The \code{rpms} object is a representation of a regression tree achieved
by recursively partioning the dataset, fitting the specified linear model
on each node seperately.
The recursive partitioning algorithm has an unbiased variable selection
and accounts for the sample design.
The algorithm accounts for one-stage of stratification and clustering as
well as unequal probability of selection.
This version does not handle missing values, so only complete cases of a 
dataset is used.
}
\details{
The dependent variable must be the same for rp_equ and e_equ, 
 but recommended that the independent variables be different.  Categorical 
 variables with many categories in the rp_equ will cause the algorithm to 
 take a long time to run.
}
\examples{
{
# model mean of retirement contributions with a binary tree while accounting 
# for clusterd data

rpms(FINDRETX~EDUC_REF+AGE_REF+BLS_URBN+REGION, data = CE,  clusters=~CID)
     
     
# model linear fit between retirement contributions and amount of income
# with a regression tree while accounting for clusterd data

rpms(FINDRETX~EDUC_REF+AGE_REF+BLS_URBN+REGION, data=CE,
     e_equ=FINDRETX~FINCBTAX, clusters=~CID)     
}

}

