% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevalence.R
\name{prevalence_counted}
\alias{prevalence_counted}
\title{Count prevalence from registry data. Counts prevalence at a specific index
date using registry data.}
\usage{
prevalence_counted(entry, eventdate, status, start = NULL,
  num_reg_years = NULL)
}
\arguments{
\item{entry}{Vector of diagnosis dates for each patient in the registry in
the format YYYY-MM-DD.}

\item{eventdate}{Vector of dates corresponding to the indicator variable in
the format YYYY-MM-DD.}

\item{status}{Vector of binary values indicating if an event has occurred for
each patient in the registry. \code{entry}, \code{eventdate}, and
\code{status} must all have the same length.}

\item{start}{Date from which incident cases are included in the format
YYYY-MM-DD. Defaults to the earliest entry date.}

\item{num_reg_years}{The number of years of the registry for which incidence
is to be calculated. Defaults to using all available complete years. Note
that if more registry years are supplied than the number of years to
estimate prevalence for, the survival data from the surplus registry years
are still involved in the survival model fitting.}
}
\value{
A vector of length \code{num_reg_years}, representing the number of
  incident cases in the corresponding year that contribute to the prevalence
  at the index date.
}
\description{
Count prevalence from registry data. Counts prevalence at a specific index
date using registry data.
}
\examples{
data(prevsim)

prevalence_counted(prevsim$entrydate,
                   prevsim$eventdate,
                   prevsim$status)

prevalence_counted(prevsim$entrydate,
                   prevsim$eventdate,
                   prevsim$status,
                   start="2004-01-30", num_reg_years=8)

}
\seealso{
Other prevalence functions: \code{\link{prevalence_simulated}},
  \code{\link{prevalence}},
  \code{\link{test_prevalence_fit}}
}

